/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.api.measurecomputer;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.measure.Component;

@Immutable
public class ComponentImpl
implements Component {
    private final String key;
    private final Component.Type type;
    @CheckForNull
    private final Component.FileAttributes fileAttributes;

    public ComponentImpl(String key, Component.Type type, @Nullable Component.FileAttributes fileAttributes) {
        this.key = Objects.requireNonNull(key, "Key cannot be null");
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.fileAttributes = this.checkFileAttributes(fileAttributes);
    }

    @CheckForNull
    private Component.FileAttributes checkFileAttributes(@Nullable Component.FileAttributes fileAttributes) {
        if (fileAttributes == null && this.type == Component.Type.FILE) {
            throw new IllegalArgumentException("Component of type FILE must have a FileAttributes object");
        }
        if (fileAttributes != null && this.type != Component.Type.FILE) {
            throw new IllegalArgumentException("Only component of type FILE have a FileAttributes object");
        }
        return fileAttributes;
    }

    public Component.Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public Component.FileAttributes getFileAttributes() {
        Preconditions.checkState((this.type == Component.Type.FILE ? 1 : 0) != 0, (Object)"Only component of type FILE have a FileAttributes object");
        return this.fileAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentImpl component = (ComponentImpl)o;
        return this.key.equals(component.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "ComponentImpl{key=" + this.key + ", type='" + this.type + '\'' + ", fileAttributes=" + this.fileAttributes + '}';
    }

    @Immutable
    public static class FileAttributesImpl
    implements Component.FileAttributes {
        private final boolean unitTest;
        private final String languageKey;

        public FileAttributesImpl(@Nullable String languageKey, boolean unitTest) {
            this.languageKey = languageKey;
            this.unitTest = unitTest;
        }

        public boolean isUnitTest() {
            return this.unitTest;
        }

        @CheckForNull
        public String getLanguageKey() {
            return this.languageKey;
        }

        public String toString() {
            return "FileAttributesImpl{languageKey='" + this.languageKey + '\'' + ", unitTest=" + this.unitTest + '}';
        }
    }
}

