/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.filemove;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.projectanalysis.filemove.ScoreMatrix;
import org.sonar.ce.task.projectanalysis.filemove.ScoreMatrixDumper;

public class ScoreMatrixDumperImpl
implements ScoreMatrixDumper {
    private static final Logger LOG = Loggers.get(ScoreMatrixDumperImpl.class);
    private final Configuration configuration;
    private final CeTask ceTask;

    public ScoreMatrixDumperImpl(Configuration configuration, CeTask ceTask) {
        this.configuration = configuration;
        this.ceTask = ceTask;
    }

    @Override
    public void dumpAsCsv(ScoreMatrix scoreMatrix) {
        if (this.configuration.getBoolean("sonar.filemove.dumpCsv").orElse(false).booleanValue()) {
            try {
                Path tempFile = Files.createTempFile(String.format("score-matrix-%s", this.ceTask.getUuid()), ".csv", new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(tempFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                    writer.write(scoreMatrix.toCsv(';'));
                }
                LOG.info("File move similarity score matrix dumped as CSV: {}", (Object)tempFile);
            }
            catch (IOException e) {
                LOG.error("Failed to dump ScoreMatrix as CSV", (Throwable)e);
            }
        }
    }
}

