/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.formula;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.formula.CreateMeasureContext;
import org.sonar.ce.task.projectanalysis.formula.Formula;
import org.sonar.ce.task.projectanalysis.formula.counter.IntSumCounter;
import org.sonar.ce.task.projectanalysis.formula.counter.LongSumCounter;
import org.sonar.ce.task.projectanalysis.formula.counter.SumCounter;
import org.sonar.ce.task.projectanalysis.measure.Measure;

public abstract class SumFormula<T extends SumCounter<U, T>, U extends Number>
implements Formula<T> {
    protected final String metricKey;
    @CheckForNull
    protected final U defaultInputValue;

    public SumFormula(String metricKey, @Nullable U defaultInputValue) {
        this.metricKey = Objects.requireNonNull(metricKey, "Metric key cannot be null");
        this.defaultInputValue = defaultInputValue;
    }

    public static IntSumFormula createIntSumFormula(String metricKey) {
        return SumFormula.createIntSumFormula(metricKey, null);
    }

    public static IntSumFormula createIntSumFormula(String metricKey, @Nullable Integer defaultInputValue) {
        return new IntSumFormula(metricKey, defaultInputValue);
    }

    public static LongSumFormula createLongSumFormula(String metricKey) {
        return SumFormula.createLongSumFormula(metricKey, null);
    }

    public static LongSumFormula createLongSumFormula(String metricKey, @Nullable Long defaultInputValue) {
        return new LongSumFormula(metricKey, defaultInputValue);
    }

    private static <T extends Number> boolean shouldCreateMeasure(CreateMeasureContext context, Optional<T> value) {
        return value.isPresent() && CrawlerDepthLimit.LEAVES.isDeeperThan(context.getComponent().getType());
    }

    @Override
    public String[] getOutputMetricKeys() {
        return new String[]{this.metricKey};
    }

    public static class LongSumFormula
    extends SumFormula<LongSumCounter, Long> {
        private LongSumFormula(String metricKey, @Nullable Long defaultInputValue) {
            super(metricKey, defaultInputValue);
        }

        @Override
        public LongSumCounter createNewCounter() {
            return new LongSumCounter(this.metricKey, (Long)this.defaultInputValue);
        }

        @Override
        public Optional<Measure> createMeasure(LongSumCounter counter, CreateMeasureContext context) {
            Optional<Long> valueOptional = counter.getValue();
            if (SumFormula.shouldCreateMeasure(context, valueOptional)) {
                return Optional.of(Measure.newMeasureBuilder().create(valueOptional.get()));
            }
            return Optional.empty();
        }
    }

    public static class IntSumFormula
    extends SumFormula<IntSumCounter, Integer> {
        private IntSumFormula(String metricKey, @Nullable Integer defaultInputValue) {
            super(metricKey, defaultInputValue);
        }

        @Override
        public IntSumCounter createNewCounter() {
            return new IntSumCounter(this.metricKey, (Integer)this.defaultInputValue);
        }

        @Override
        public Optional<Measure> createMeasure(IntSumCounter counter, CreateMeasureContext context) {
            Optional<Integer> valueOptional = counter.getValue();
            if (SumFormula.shouldCreateMeasure(context, valueOptional)) {
                return Optional.of(Measure.newMeasureBuilder().create(valueOptional.get()));
            }
            return Optional.empty();
        }
    }
}

