/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.List;
import java.util.Set;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.ComponentsWithUnprocessedIssues;
import org.sonar.ce.task.projectanalysis.issue.IssueCache;
import org.sonar.ce.task.projectanalysis.issue.IssueLifecycle;
import org.sonar.ce.task.projectanalysis.util.cache.DiskCache;
import org.sonar.core.issue.DefaultIssue;

public class CloseIssuesOnRemovedComponentsVisitor
extends TypeAwareVisitorAdapter {
    private final ComponentIssuesLoader issuesLoader;
    private final ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues;
    private final IssueCache issueCache;
    private final IssueLifecycle issueLifecycle;

    public CloseIssuesOnRemovedComponentsVisitor(ComponentIssuesLoader issuesLoader, ComponentsWithUnprocessedIssues componentsWithUnprocessedIssues, IssueCache issueCache, IssueLifecycle issueLifecycle) {
        super(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.POST_ORDER);
        this.issuesLoader = issuesLoader;
        this.componentsWithUnprocessedIssues = componentsWithUnprocessedIssues;
        this.issueCache = issueCache;
        this.issueLifecycle = issueLifecycle;
    }

    @Override
    public void visitProject(Component project) {
        this.closeIssuesForDeletedComponentUuids(this.componentsWithUnprocessedIssues.getUuids());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIssuesForDeletedComponentUuids(Set<String> deletedComponentUuids) {
        try (DiskCache.DiskAppender cacheAppender = this.issueCache.newAppender();){
            for (String deletedComponentUuid : deletedComponentUuids) {
                List<DefaultIssue> issues = this.issuesLoader.loadOpenIssues(deletedComponentUuid);
                for (DefaultIssue issue : issues) {
                    issue.setBeingClosed(true);
                    issue.setOnDisabledRule(false);
                    this.issueLifecycle.doAutomaticTransition(issue);
                    cacheAppender.append(issue);
                }
            }
        }
    }
}

