/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Collections;
import java.util.stream.Stream;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.MergeBranchTrackerExecution;
import org.sonar.ce.task.projectanalysis.issue.ShortBranchOrPullRequestTrackerExecution;
import org.sonar.ce.task.projectanalysis.issue.TrackerExecution;
import org.sonar.ce.task.projectanalysis.issue.TrackingResult;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.db.component.BranchType;

public class IssueTrackingDelegator {
    private final ShortBranchOrPullRequestTrackerExecution shortBranchOrPullRequestTracker;
    private final TrackerExecution tracker;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MergeBranchTrackerExecution mergeBranchTracker;

    public IssueTrackingDelegator(ShortBranchOrPullRequestTrackerExecution shortBranchOrPullRequestTracker, MergeBranchTrackerExecution longBranchTracker, TrackerExecution tracker, AnalysisMetadataHolder analysisMetadataHolder) {
        this.shortBranchOrPullRequestTracker = shortBranchOrPullRequestTracker;
        this.mergeBranchTracker = longBranchTracker;
        this.tracker = tracker;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public TrackingResult track(Component component) {
        if (this.analysisMetadataHolder.isSLBorPR()) {
            return IssueTrackingDelegator.standardResult(this.shortBranchOrPullRequestTracker.track(component));
        }
        if (this.isFirstAnalysisSecondaryLongLivingBranch()) {
            Tracking<DefaultIssue, DefaultIssue> tracking = this.mergeBranchTracker.track(component);
            return new TrackingResult(tracking.getMatchedRaws(), Collections.emptyMap(), Stream.empty(), tracking.getUnmatchedRaws());
        }
        return IssueTrackingDelegator.standardResult(this.tracker.track(component));
    }

    private static TrackingResult standardResult(Tracking<DefaultIssue, DefaultIssue> tracking) {
        return new TrackingResult(Collections.emptyMap(), tracking.getMatchedRaws(), tracking.getUnmatchedBases(), tracking.getUnmatchedRaws());
    }

    private boolean isFirstAnalysisSecondaryLongLivingBranch() {
        if (this.analysisMetadataHolder.isFirstAnalysis()) {
            Branch branch = this.analysisMetadataHolder.getBranch();
            return !branch.isMain() && branch.getType() == BranchType.LONG;
        }
        return false;
    }
}

