/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.utils.DateUtils;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitor;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.period.PeriodHolder;
import org.sonar.core.issue.DefaultIssue;

public class NewEffortAggregator
extends IssueVisitor {
    private final Map<String, NewEffortCounter> counterByComponentUuid = new HashMap<String, NewEffortCounter>();
    private final PeriodHolder periodHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MeasureRepository measureRepository;
    private final Metric newMaintainabilityEffortMetric;
    private final Metric newReliabilityEffortMetric;
    private final Metric newSecurityEffortMetric;
    private NewEffortCounter counter = null;

    public NewEffortAggregator(PeriodHolder periodHolder, AnalysisMetadataHolder analysisMetadataHolder, MetricRepository metricRepository, MeasureRepository measureRepository) {
        this.periodHolder = periodHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.measureRepository = measureRepository;
        this.newMaintainabilityEffortMetric = metricRepository.getByKey("new_technical_debt");
        this.newReliabilityEffortMetric = metricRepository.getByKey("new_reliability_remediation_effort");
        this.newSecurityEffortMetric = metricRepository.getByKey("new_security_remediation_effort");
    }

    @Override
    public void beforeComponent(Component component) {
        this.counter = new NewEffortCounter();
        this.counterByComponentUuid.put(component.getUuid(), this.counter);
        for (Component child : component.getChildren()) {
            NewEffortCounter childSum = this.counterByComponentUuid.remove(child.getUuid());
            if (childSum == null) continue;
            this.counter.add(childSum);
        }
    }

    @Override
    public void onIssue(Component component, DefaultIssue issue) {
        if (issue.resolution() == null && issue.effortInMinutes() != null) {
            if (this.analysisMetadataHolder.isSLBorPR()) {
                this.counter.add(issue, 0L);
            } else if (this.periodHolder.hasPeriod()) {
                this.counter.add(issue, this.periodHolder.getPeriod().getSnapshotDate());
            }
        }
    }

    @Override
    public void afterComponent(Component component) {
        if (this.periodHolder.hasPeriod() || this.analysisMetadataHolder.isSLBorPR()) {
            this.computeMeasure(component, this.newMaintainabilityEffortMetric, this.counter.maintainabilitySum);
            this.computeMeasure(component, this.newReliabilityEffortMetric, this.counter.reliabilitySum);
            this.computeMeasure(component, this.newSecurityEffortMetric, this.counter.securitySum);
        }
        this.counter = null;
    }

    private void computeMeasure(Component component, Metric metric, EffortSum effortSum) {
        double variation = effortSum.isEmpty ? 0.0 : effortSum.newEffort;
        this.measureRepository.add(component, metric, Measure.newMeasureBuilder().setVariation(variation).createNoValue());
    }

    private static class EffortSum {
        private Double newEffort;
        private boolean isEmpty = true;

        private EffortSum() {
        }

        void add(long newEffort) {
            double previous = (Double)MoreObjects.firstNonNull((Object)this.newEffort, (Object)0.0);
            this.newEffort = previous + (double)newEffort;
            this.isEmpty = false;
        }

        void add(EffortSum other) {
            Double otherValue = other.newEffort;
            if (otherValue != null) {
                this.add(otherValue.longValue());
            }
        }
    }

    private static class NewEffortCounter {
        private final EffortSum maintainabilitySum = new EffortSum();
        private final EffortSum reliabilitySum = new EffortSum();
        private final EffortSum securitySum = new EffortSum();

        private NewEffortCounter() {
        }

        void add(NewEffortCounter otherCounter) {
            this.maintainabilitySum.add(otherCounter.maintainabilitySum);
            this.reliabilitySum.add(otherCounter.reliabilitySum);
            this.securitySum.add(otherCounter.securitySum);
        }

        void add(DefaultIssue issue, long startDate) {
            long newEffort = this.calculate(issue, startDate);
            switch (issue.type()) {
                case CODE_SMELL: {
                    this.maintainabilitySum.add(newEffort);
                    break;
                }
                case BUG: {
                    this.reliabilitySum.add(newEffort);
                    break;
                }
                case VULNERABILITY: {
                    this.securitySum.add(newEffort);
                    break;
                }
                case SECURITY_HOTSPOT: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown type '%s'", issue.type()));
                }
            }
        }

        long calculate(DefaultIssue issue, long startDate) {
            if (issue.creationDate().getTime() > DateUtils.truncateToSeconds((long)startDate)) {
                return (Long)MoreObjects.firstNonNull((Object)issue.effortInMinutes(), (Object)0L);
            }
            return 0L;
        }
    }
}

