/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.Set;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.ClosedIssuesInputFactory;
import org.sonar.ce.task.projectanalysis.issue.ComponentIssuesLoader;
import org.sonar.ce.task.projectanalysis.issue.TrackerBaseInputFactory;
import org.sonar.ce.task.projectanalysis.issue.TrackerRawInputFactory;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.NonClosedTracking;
import org.sonar.core.issue.tracking.Tracker;
import org.sonar.core.issue.tracking.Tracking;
import org.sonar.core.util.stream.MoreCollectors;

public class TrackerExecution {
    private final TrackerBaseInputFactory baseInputFactory;
    private final TrackerRawInputFactory rawInputFactory;
    private final ClosedIssuesInputFactory closedIssuesInputFactory;
    private final Tracker<DefaultIssue, DefaultIssue> tracker;
    private final ComponentIssuesLoader componentIssuesLoader;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public TrackerExecution(TrackerBaseInputFactory baseInputFactory, TrackerRawInputFactory rawInputFactory, ClosedIssuesInputFactory closedIssuesInputFactory, Tracker<DefaultIssue, DefaultIssue> tracker, ComponentIssuesLoader componentIssuesLoader, AnalysisMetadataHolder analysisMetadataHolder) {
        this.baseInputFactory = baseInputFactory;
        this.rawInputFactory = rawInputFactory;
        this.closedIssuesInputFactory = closedIssuesInputFactory;
        this.tracker = tracker;
        this.componentIssuesLoader = componentIssuesLoader;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public Tracking<DefaultIssue, DefaultIssue> track(Component component) {
        Input<DefaultIssue> openBaseIssuesInput;
        Input<DefaultIssue> rawInput = this.rawInputFactory.create(component);
        NonClosedTracking openIssueTracking = this.tracker.trackNonClosed(rawInput, openBaseIssuesInput = this.baseInputFactory.create(component));
        if (openIssueTracking.isComplete() || this.analysisMetadataHolder.isFirstAnalysis()) {
            return openIssueTracking;
        }
        Input<DefaultIssue> closedIssuesBaseInput = this.closedIssuesInputFactory.create(component);
        Tracking closedIssuesTracking = this.tracker.trackClosed(openIssueTracking, closedIssuesBaseInput);
        Set matchesClosedIssues = (Set)closedIssuesTracking.getMatchedRaws().values().stream().filter(t -> "CLOSED".equals(t.getStatus())).collect(MoreCollectors.toSet());
        this.componentIssuesLoader.loadLatestDiffChangesForReopeningOfClosedIssues(matchesClosedIssues);
        return closedIssuesTracking;
    }
}

