/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRule;
import org.sonar.ce.task.projectanalysis.issue.commonrule.CommonRuleEngine;
import org.sonar.core.issue.DefaultIssue;

public class CommonRuleEngineImpl
implements CommonRuleEngine {
    private final CommonRule[] commonRules;

    public CommonRuleEngineImpl(CommonRule ... commonRules) {
        this.commonRules = commonRules;
    }

    @Override
    public Collection<DefaultIssue> process(Component component) {
        ArrayList<DefaultIssue> result = new ArrayList<DefaultIssue>();
        String fileLanguage = CommonRuleEngineImpl.getFileLanguage(component);
        if (fileLanguage != null) {
            for (CommonRule commonRule : this.commonRules) {
                DefaultIssue issue = commonRule.processFile(component, fileLanguage);
                if (issue == null) continue;
                result.add(issue);
            }
        }
        return result;
    }

    @CheckForNull
    private static String getFileLanguage(Component component) {
        if (component.getType() == Component.Type.FILE) {
            return component.getFileAttributes().getLanguageKey();
        }
        return null;
    }
}

