/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.notifications.Notification;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class ReportAnalysisFailureNotificationHandler
extends EmailNotificationHandler<ReportAnalysisFailureNotification> {
    private static final String KEY = "CeReportTaskFailure";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create((String)"CeReportTaskFailure").setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    private static final NotificationManager.SubscriberPermissionsOnProject REQUIRED_SUBSCRIBER_PERMISSIONS = new NotificationManager.SubscriberPermissionsOnProject("admin", "user");
    private final NotificationManager notificationManager;

    public ReportAnalysisFailureNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
    }

    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    public Class<ReportAnalysisFailureNotification> getNotificationClass() {
        return ReportAnalysisFailureNotification.class;
    }

    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<ReportAnalysisFailureNotification> notifications) {
        Multimap notificationsByProjectKey = (Multimap)notifications.stream().filter(t -> t.getProjectKey() != null).collect(MoreCollectors.index(ReportAnalysisFailureNotification::getProjectKey));
        if (notificationsByProjectKey.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)notificationsByProjectKey.asMap().entrySet().stream().flatMap(e -> this.toEmailDeliveryRequests((String)e.getKey(), (Collection)e.getValue())).collect(MoreCollectors.toSet((int)notifications.size()));
    }

    private Stream<? extends EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(String projectKey, Collection<ReportAnalysisFailureNotification> notifications) {
        return this.notificationManager.findSubscribedEmailRecipients(KEY, projectKey, REQUIRED_SUBSCRIBER_PERMISSIONS).stream().flatMap(emailRecipient -> notifications.stream().map(notification -> new EmailNotificationChannel.EmailDeliveryRequest(emailRecipient.getEmail(), (Notification)notification)));
    }
}

