/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.qualityprofile;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.MutableQProfileStatusRepository;
import org.sonar.ce.task.projectanalysis.qualityprofile.QProfileStatusRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.server.qualityprofile.QPMeasureData;
import org.sonar.server.qualityprofile.QualityProfile;

public class RegisterQualityProfileStatusStep
implements ComputationStep {
    private TreeRootHolder treeRootHolder;
    private MeasureRepository measureRepository;
    private MetricRepository metricRepository;
    private MutableQProfileStatusRepository qProfileStatusRepository;
    private AnalysisMetadataHolder analysisMetadataHolder;

    public RegisterQualityProfileStatusStep(TreeRootHolder treeRootHolder, MeasureRepository measureRepository, MetricRepository metricRepository, MutableQProfileStatusRepository qProfileStatusRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
        this.metricRepository = metricRepository;
        this.qProfileStatusRepository = qProfileStatusRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    public void execute(ComputationStep.Context context) {
        new DepthTraversalTypeAwareCrawler(new TypeAwareVisitorAdapter(CrawlerDepthLimit.PROJECT, ComponentVisitor.Order.POST_ORDER){

            @Override
            public void visitProject(Component tree) {
                RegisterQualityProfileStatusStep.this.executeForProject(tree);
            }
        }).visit(this.treeRootHolder.getRoot());
    }

    private void executeForProject(Component project) {
        this.measureRepository.getBaseMeasure(project, this.metricRepository.getByKey("quality_profiles")).ifPresent(baseProfilesMeasure -> {
            Map<String, QualityProfile> baseProfiles = RegisterQualityProfileStatusStep.parseJsonData(baseProfilesMeasure);
            Map<String, QualityProfile> rawProfiles = this.analysisMetadataHolder.getQProfilesByLanguage().values().stream().collect(Collectors.toMap(QualityProfile::getQpKey, q -> q));
            this.registerNoMoreUsedProfiles(baseProfiles, rawProfiles);
            this.registerNewOrUpdatedProfiles(baseProfiles, rawProfiles);
        });
    }

    private void registerNoMoreUsedProfiles(Map<String, QualityProfile> baseProfiles, Map<String, QualityProfile> rawProfiles) {
        for (QualityProfile baseProfile : baseProfiles.values()) {
            if (rawProfiles.containsKey(baseProfile.getQpKey())) continue;
            this.register(baseProfile, QProfileStatusRepository.Status.REMOVED);
        }
    }

    private void registerNewOrUpdatedProfiles(Map<String, QualityProfile> baseProfiles, Map<String, QualityProfile> rawProfiles) {
        for (QualityProfile profile : rawProfiles.values()) {
            QualityProfile baseProfile = baseProfiles.get(profile.getQpKey());
            if (baseProfile == null) {
                this.register(profile, QProfileStatusRepository.Status.ADDED);
                continue;
            }
            if (profile.getRulesUpdatedAt().after(baseProfile.getRulesUpdatedAt())) {
                this.register(baseProfile, QProfileStatusRepository.Status.UPDATED);
                continue;
            }
            this.register(baseProfile, QProfileStatusRepository.Status.UNCHANGED);
        }
    }

    private void register(QualityProfile profile, QProfileStatusRepository.Status status) {
        this.qProfileStatusRepository.register(profile.getQpKey(), status);
    }

    private static Map<String, QualityProfile> parseJsonData(Measure measure) {
        String data = measure.getStringValue();
        if (data == null) {
            return Collections.emptyMap();
        }
        return QPMeasureData.fromJson((String)data).getProfilesByKey();
    }

    public String getDescription() {
        return "Compute Quality Profile status";
    }
}

