/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.source;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.MergeAndTargetBranchComponentUuids;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.source.SourceLinesDiff;
import org.sonar.ce.task.projectanalysis.source.SourceLinesDiffFinder;
import org.sonar.ce.task.projectanalysis.source.SourceLinesHashRepository;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDao;

public class SourceLinesDiffImpl
implements SourceLinesDiff {
    private final DbClient dbClient;
    private final FileSourceDao fileSourceDao;
    private final SourceLinesHashRepository sourceLinesHash;
    private final MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids;
    private final MovedFilesRepository movedFilesRepository;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public SourceLinesDiffImpl(DbClient dbClient, FileSourceDao fileSourceDao, SourceLinesHashRepository sourceLinesHash, MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids, MovedFilesRepository movedFilesRepository, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.fileSourceDao = fileSourceDao;
        this.sourceLinesHash = sourceLinesHash;
        this.mergeAndTargetBranchComponentUuids = mergeAndTargetBranchComponentUuids;
        this.movedFilesRepository = movedFilesRepository;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public int[] computeMatchingLines(Component component) {
        List<String> database = this.getDBLines(component);
        List<String> report = this.getReportLines(component);
        return new SourceLinesDiffFinder().findMatchingLines(database, report);
    }

    private List<String> getDBLines(Component component) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Object originalFile;
            String uuid;
            if (this.analysisMetadataHolder.isSLBorPR()) {
                uuid = this.mergeAndTargetBranchComponentUuids.getTargetBranchComponentUuid(component.getDbKey());
                if (uuid == null) {
                    uuid = this.mergeAndTargetBranchComponentUuids.getMergeBranchComponentUuid(component.getDbKey());
                }
            } else {
                originalFile = this.movedFilesRepository.getOriginalFile(component);
                uuid = ((Optional)originalFile).map(MovedFilesRepository.OriginalFile::getUuid).orElse(component.getUuid());
            }
            if (uuid == null) {
                originalFile = Collections.emptyList();
                return originalFile;
            }
            List database = this.fileSourceDao.selectLineHashes(dbSession, uuid);
            if (database == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            List list = database;
            return list;
        }
    }

    private List<String> getReportLines(Component component) {
        return this.sourceLinesHash.getLineHashesMatchingDBVersion(component);
    }
}

