/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.sonar.db.DbSession;

abstract class DelegatingDbSession
implements DbSession {
    private final DbSession delegate;

    DelegatingDbSession(DbSession delegate) {
        this.delegate = delegate;
    }

    public DbSession getDelegate() {
        return this.delegate;
    }

    public void close() {
        this.doClose();
    }

    protected abstract void doClose();

    public <T> Cursor<T> selectCursor(String statement) {
        return this.delegate.selectCursor(statement);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter) {
        return this.delegate.selectCursor(statement, parameter);
    }

    public <T> Cursor<T> selectCursor(String statement, Object parameter, RowBounds rowBounds) {
        return this.delegate.selectCursor(statement, parameter, rowBounds);
    }

    public <T> T selectOne(String statement) {
        return (T)this.delegate.selectOne(statement);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.delegate.selectOne(statement, parameter);
    }

    public <E> List<E> selectList(String statement) {
        return this.delegate.selectList(statement);
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.delegate.selectList(statement, parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.delegate.selectList(statement, parameter, rowBounds);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.delegate.selectMap(statement, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.delegate.selectMap(statement, parameter, mapKey);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.delegate.selectMap(statement, parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.delegate.select(statement, parameter, handler);
    }

    public void select(String statement, ResultHandler handler) {
        this.delegate.select(statement, handler);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.delegate.select(statement, parameter, rowBounds, handler);
    }

    public int insert(String statement) {
        return this.delegate.insert(statement);
    }

    public int insert(String statement, Object parameter) {
        return this.delegate.insert(statement, parameter);
    }

    public int update(String statement) {
        return this.delegate.update(statement);
    }

    public int update(String statement, Object parameter) {
        return this.delegate.update(statement, parameter);
    }

    public int delete(String statement) {
        return this.delegate.delete(statement);
    }

    public int delete(String statement, Object parameter) {
        return this.delegate.delete(statement, parameter);
    }

    public void commit() {
        this.delegate.commit();
    }

    public void commit(boolean force) {
        this.delegate.commit(force);
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void rollback(boolean force) {
        this.delegate.rollback(force);
    }

    public List<BatchResult> flushStatements() {
        return this.delegate.flushStatements();
    }

    public void clearCache() {
        this.delegate.clearCache();
    }

    public Configuration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public <T> T getMapper(Class<T> type) {
        return (T)this.delegate.getMapper(type);
    }

    public Connection getConnection() {
        return this.delegate.getConnection();
    }

    @Override
    public SqlSession getSqlSession() {
        return this.delegate.getSqlSession();
    }
}

