/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;
import org.sonar.db.component.ComponentValidator;
import org.sonar.db.component.DbTagsReader;

public class ComponentDto {
    public static final String BRANCH_KEY_SEPARATOR = ":BRANCH:";
    public static final String PULL_REQUEST_SEPARATOR = ":PULL_REQUEST:";
    private static final Splitter BRANCH_OR_PULL_REQUEST_SPLITTER = Splitter.on((Pattern)Pattern.compile(":BRANCH:|:PULL_REQUEST:"));
    private static final Splitter BRANCH_KEY_SPLITTER = Splitter.on((String)":BRANCH:");
    private static final Splitter PULL_REQUEST_SPLITTER = Splitter.on((String)":PULL_REQUEST:");
    public static final String UUID_PATH_SEPARATOR = ".";
    public static final String UUID_PATH_OF_ROOT = ".";
    private static final Splitter UUID_PATH_SPLITTER = Splitter.on((String)".").omitEmptyStrings();
    static final char TAGS_SEPARATOR = ',';
    private static final Joiner TAGS_JOINER = Joiner.on((char)',').skipNulls();
    private Long id;
    private String organizationUuid;
    private String kee;
    private String uuid;
    private String uuidPath;
    private String projectUuid;
    private String rootUuid;
    @Nullable
    private String mainBranchProjectUuid;
    private String moduleUuid;
    private String moduleUuidPath;
    private String copyComponentUuid;
    private String scope;
    private String qualifier;
    private String path;
    private String name;
    private String longName;
    private String language;
    private String description;
    private String tags;
    private boolean enabled = true;
    private boolean isPrivate = false;
    private Date createdAt;

    public static String formatUuidPathFromParent(ComponentDto parent) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parent.getUuidPath()) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)parent.uuid()) ? 1 : 0) != 0);
        return parent.getUuidPath() + parent.uuid() + ".";
    }

    public String getUuidPathLikeIncludingSelf() {
        return DaoUtils.buildLikeValue(ComponentDto.formatUuidPathFromParent(this), WildcardPosition.AFTER);
    }

    public Long getId() {
        return this.id;
    }

    public ComponentDto setId(Long id) {
        this.id = id;
        return this;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public ComponentDto setOrganizationUuid(String organizationUuid) {
        this.organizationUuid = organizationUuid;
        return this;
    }

    public String uuid() {
        return this.uuid;
    }

    public ComponentDto setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getUuidPath() {
        return this.uuidPath;
    }

    public ComponentDto setUuidPath(String s) {
        this.uuidPath = s;
        return this;
    }

    public List<String> getUuidPathAsList() {
        return UUID_PATH_SPLITTER.splitToList((CharSequence)this.uuidPath);
    }

    public String getDbKey() {
        return this.kee;
    }

    public ComponentDto setDbKey(String key) {
        this.kee = ComponentValidator.checkComponentKey(key);
        return this;
    }

    public String getKey() {
        List split = BRANCH_OR_PULL_REQUEST_SPLITTER.splitToList((CharSequence)this.kee);
        return split.size() == 2 ? (String)split.get(0) : this.kee;
    }

    @CheckForNull
    public String getBranch() {
        List split = BRANCH_KEY_SPLITTER.splitToList((CharSequence)this.kee);
        return split.size() == 2 ? (String)split.get(1) : null;
    }

    @CheckForNull
    public String getPullRequest() {
        List split = PULL_REQUEST_SPLITTER.splitToList((CharSequence)this.kee);
        return split.size() == 2 ? (String)split.get(1) : null;
    }

    public String scope() {
        return this.scope;
    }

    public ComponentDto setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public ComponentDto setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public String projectUuid() {
        return this.projectUuid;
    }

    public ComponentDto setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
        return this;
    }

    public boolean isRoot() {
        return ".".equals(this.uuidPath);
    }

    @CheckForNull
    public String moduleUuid() {
        return this.moduleUuid;
    }

    public ComponentDto setModuleUuid(@Nullable String moduleUuid) {
        this.moduleUuid = moduleUuid;
        return this;
    }

    public String moduleUuidPath() {
        return this.moduleUuidPath;
    }

    public ComponentDto setModuleUuidPath(String moduleUuidPath) {
        this.moduleUuidPath = moduleUuidPath;
        return this;
    }

    @CheckForNull
    public String path() {
        return this.path;
    }

    public ComponentDto setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ComponentDto setName(String name) {
        this.name = ComponentValidator.checkComponentName(name);
        return this;
    }

    public String longName() {
        return this.longName;
    }

    public ComponentDto setLongName(String longName) {
        this.longName = ComponentValidator.checkComponentLongName(longName);
        return this;
    }

    @CheckForNull
    public String language() {
        return this.language;
    }

    public ComponentDto setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    @CheckForNull
    public String description() {
        return this.description;
    }

    public ComponentDto setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Deprecated
    public String getRootUuid() {
        return this.rootUuid;
    }

    public ComponentDto setRootUuid(String rootUuid) {
        this.rootUuid = rootUuid;
        return this;
    }

    @Nullable
    public String getMainBranchProjectUuid() {
        return this.mainBranchProjectUuid;
    }

    public ComponentDto setMainBranchProjectUuid(@Nullable String s) {
        this.mainBranchProjectUuid = s;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ComponentDto setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @CheckForNull
    public String getCopyResourceUuid() {
        return this.copyComponentUuid;
    }

    public ComponentDto setCopyComponentUuid(@Nullable String copyComponentUuid) {
        this.copyComponentUuid = copyComponentUuid;
        return this;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public ComponentDto setCreatedAt(Date datetime) {
        this.createdAt = datetime;
        return this;
    }

    public boolean isRootProject() {
        return this.moduleUuid == null && "PRJ".equals(this.scope);
    }

    public List<String> getTags() {
        return DbTagsReader.readDbTags(this.tags);
    }

    public ComponentDto setTags(List<String> tags) {
        this.setTagsString(TAGS_JOINER.join(tags));
        return this;
    }

    @CheckForNull
    public String getTagsString() {
        return this.tags;
    }

    public ComponentDto setTagsString(@Nullable String tags) {
        this.tags = tags;
        return this;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public ComponentDto setPrivate(boolean flag) {
        this.isPrivate = flag;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDto that = (ComponentDto)o;
        return this.uuid != null ? this.uuid.equals(that.uuid) : that.uuid == null;
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("uuid", (Object)this.uuid).append("uuidPath", (Object)this.uuidPath).append("kee", (Object)this.kee).append("scope", (Object)this.scope).append("qualifier", (Object)this.qualifier).append("projectUuid", (Object)this.projectUuid).append("moduleUuid", (Object)this.moduleUuid).append("moduleUuidPath", (Object)this.moduleUuidPath).append("rootUuid", (Object)this.rootUuid).append("mainBranchProjectUuid", (Object)this.mainBranchProjectUuid).append("copyComponentUuid", (Object)this.copyComponentUuid).append("path", (Object)this.path).append("name", (Object)this.name).append("longName", (Object)this.longName).append("language", (Object)this.language).append("enabled", this.enabled).append("private", this.isPrivate).toString();
    }

    public ComponentDto copy() {
        ComponentDto copy = new ComponentDto();
        copy.projectUuid = this.projectUuid;
        copy.id = this.id;
        copy.organizationUuid = this.organizationUuid;
        copy.kee = this.kee;
        copy.uuid = this.uuid;
        copy.uuidPath = this.uuidPath;
        copy.projectUuid = this.projectUuid;
        copy.rootUuid = this.rootUuid;
        copy.mainBranchProjectUuid = this.mainBranchProjectUuid;
        copy.moduleUuid = this.moduleUuid;
        copy.moduleUuidPath = this.moduleUuidPath;
        copy.copyComponentUuid = this.copyComponentUuid;
        copy.scope = this.scope;
        copy.qualifier = this.qualifier;
        copy.path = this.path;
        copy.name = this.name;
        copy.longName = this.longName;
        copy.language = this.language;
        copy.description = this.description;
        copy.tags = this.tags;
        copy.enabled = this.enabled;
        copy.isPrivate = this.isPrivate;
        copy.createdAt = this.createdAt;
        return copy;
    }

    public static String generateBranchKey(String componentKey, String branch) {
        return String.format("%s%s%s", componentKey, BRANCH_KEY_SEPARATOR, branch);
    }

    public static String generatePullRequestKey(String componentKey, String pullRequest) {
        return String.format("%s%s%s", componentKey, PULL_REQUEST_SEPARATOR, pullRequest);
    }

    public static String removeBranchAndPullRequestFromKey(String componentKey) {
        return StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)componentKey, (String)BRANCH_KEY_SEPARATOR), (String)PULL_REQUEST_SEPARATOR);
    }
}

