/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure.custom;

import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.measure.custom.CustomMeasureMapper;

public class CustomMeasureDao
implements Dao {
    public void insert(DbSession session, CustomMeasureDto customMeasureDto) {
        CustomMeasureDao.mapper(session).insert(customMeasureDto);
    }

    public void update(DbSession session, CustomMeasureDto customMeasure) {
        CustomMeasureDao.mapper(session).update(customMeasure);
    }

    public void delete(DbSession session, long id) {
        CustomMeasureDao.mapper(session).delete(id);
    }

    public void deleteByMetricIds(DbSession session, List<Integer> metricIds) {
        DatabaseUtils.executeLargeInputsWithoutOutput(metricIds, input -> CustomMeasureDao.mapper(session).deleteByMetricIds(metricIds));
    }

    @CheckForNull
    public CustomMeasureDto selectById(DbSession session, long id) {
        return CustomMeasureDao.mapper(session).selectById(id);
    }

    public List<CustomMeasureDto> selectByMetricId(DbSession session, int metricId) {
        return CustomMeasureDao.mapper(session).selectByMetricId(metricId);
    }

    public int countByComponentIdAndMetricId(DbSession session, String componentUuid, int metricId) {
        return CustomMeasureDao.mapper(session).countByComponentIdAndMetricId(componentUuid, metricId);
    }

    public List<CustomMeasureDto> selectByComponentUuid(DbSession session, String componentUuid, int offset, int limit) {
        return CustomMeasureDao.mapper(session).selectByComponentUuid(componentUuid, new RowBounds(offset, limit));
    }

    public List<CustomMeasureDto> selectByComponentUuid(DbSession session, String componentUuid) {
        return CustomMeasureDao.mapper(session).selectByComponentUuid(componentUuid);
    }

    public List<CustomMeasureDto> selectByMetricKeyAndTextValue(DbSession session, String metricKey, String textValue) {
        return CustomMeasureDao.mapper(session).selectByMetricKeyAndTextValue(metricKey, textValue);
    }

    private static CustomMeasureMapper mapper(DbSession session) {
        return (CustomMeasureMapper)session.getMapper(CustomMeasureMapper.class);
    }

    public int countByComponentUuid(DbSession dbSession, String uuid) {
        return CustomMeasureDao.mapper(dbSession).countByComponentUuid(uuid);
    }
}

