/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.user;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.user.DefaultUser;

public class UserDto {
    public static final char SCM_ACCOUNTS_SEPARATOR = '\n';
    private String uuid;
    private Integer id;
    private String login;
    private String name;
    private String email;
    private boolean active = true;
    private String scmAccounts;
    private String externalId;
    private String externalLogin;
    private String externalIdentityProvider;
    private String cryptedPassword;
    private String salt;
    private String hashMethod;
    private String homepageType;
    private String homepageParameter;
    private boolean local = true;
    private boolean root = false;
    private boolean onboarded = false;
    private String organizationUuid;
    @Nullable
    private Long lastConnectionDate;
    private Long createdAt;
    private Long updatedAt;

    public String getUuid() {
        return this.uuid;
    }

    UserDto setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public Integer getId() {
        return this.id;
    }

    public UserDto setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getLogin() {
        return this.login;
    }

    public UserDto setLogin(String login) {
        this.login = login;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public UserDto setName(String name) {
        this.name = name;
        return this;
    }

    @CheckForNull
    public String getEmail() {
        return this.email;
    }

    public UserDto setEmail(@Nullable String email) {
        this.email = email;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public UserDto setActive(boolean b) {
        this.active = b;
        return this;
    }

    @CheckForNull
    public String getScmAccounts() {
        return this.scmAccounts;
    }

    public List<String> getScmAccountsAsList() {
        return UserDto.decodeScmAccounts(this.scmAccounts);
    }

    public UserDto setScmAccounts(@Nullable String s) {
        this.scmAccounts = s;
        return this;
    }

    public UserDto setScmAccounts(@Nullable List<String> list) {
        this.scmAccounts = UserDto.encodeScmAccounts(list);
        return this;
    }

    @CheckForNull
    public static String encodeScmAccounts(@Nullable List<String> scmAccounts) {
        if (scmAccounts != null && !scmAccounts.isEmpty()) {
            return String.format("%s%s%s", Character.valueOf('\n'), String.join((CharSequence)String.valueOf('\n'), scmAccounts), Character.valueOf('\n'));
        }
        return null;
    }

    public static List<String> decodeScmAccounts(@Nullable String dbValue) {
        if (dbValue == null) {
            return new ArrayList<String>();
        }
        return Lists.newArrayList((Iterable)Splitter.on((char)'\n').omitEmptyStrings().split((CharSequence)dbValue));
    }

    public String getExternalId() {
        return this.externalId;
    }

    public UserDto setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public String getExternalLogin() {
        return this.externalLogin;
    }

    public UserDto setExternalLogin(String externalLogin) {
        this.externalLogin = externalLogin;
        return this;
    }

    public String getExternalIdentityProvider() {
        return this.externalIdentityProvider;
    }

    public UserDto setExternalIdentityProvider(String externalIdentityProvider) {
        this.externalIdentityProvider = externalIdentityProvider;
        return this;
    }

    public boolean isLocal() {
        return this.local;
    }

    public UserDto setLocal(boolean local) {
        this.local = local;
        return this;
    }

    @CheckForNull
    public String getCryptedPassword() {
        return this.cryptedPassword;
    }

    public UserDto setCryptedPassword(@Nullable String cryptedPassword) {
        this.cryptedPassword = cryptedPassword;
        return this;
    }

    @CheckForNull
    public String getSalt() {
        return this.salt;
    }

    public UserDto setSalt(@Nullable String salt) {
        this.salt = salt;
        return this;
    }

    @CheckForNull
    public String getHashMethod() {
        return this.hashMethod;
    }

    public UserDto setHashMethod(@Nullable String hashMethod) {
        this.hashMethod = hashMethod;
        return this;
    }

    @CheckForNull
    public String getHomepageType() {
        return this.homepageType;
    }

    public UserDto setHomepageType(@Nullable String homepageType) {
        this.homepageType = homepageType;
        return this;
    }

    @CheckForNull
    public String getHomepageParameter() {
        return this.homepageParameter;
    }

    public UserDto setHomepageParameter(@Nullable String homepageParameter) {
        this.homepageParameter = homepageParameter;
        return this;
    }

    public boolean isRoot() {
        return this.root;
    }

    protected void setRoot(boolean root) {
        this.root = root;
    }

    public boolean isOnboarded() {
        return this.onboarded;
    }

    public UserDto setOnboarded(boolean onboarded) {
        this.onboarded = onboarded;
        return this;
    }

    @CheckForNull
    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public UserDto setOrganizationUuid(@Nullable String organizationUuid) {
        this.organizationUuid = organizationUuid;
        return this;
    }

    @CheckForNull
    public Long getLastConnectionDate() {
        return this.lastConnectionDate;
    }

    public UserDto setLastConnectionDate(@Nullable Long lastConnectionDate) {
        this.lastConnectionDate = lastConnectionDate;
        return this;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    UserDto setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    UserDto setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public DefaultUser toUser() {
        return new DefaultUser().setLogin(this.login).setName(this.name).setEmail(this.email).setActive(this.active);
    }
}

