/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.webhook;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.webhook.WebhookDeliveryDto;
import org.sonar.db.webhook.WebhookDeliveryLiteDto;
import org.sonar.db.webhook.WebhookDeliveryMapper;
import org.sonar.db.webhook.WebhookDto;

public class WebhookDeliveryDao
implements Dao {
    public Optional<WebhookDeliveryDto> selectByUuid(DbSession dbSession, String uuid) {
        return Optional.ofNullable(WebhookDeliveryDao.mapper(dbSession).selectByUuid(uuid));
    }

    public int countDeliveriesByWebhookUuid(DbSession dbSession, String webhookUuid) {
        return WebhookDeliveryDao.mapper(dbSession).countByWebhookUuid(webhookUuid);
    }

    public List<WebhookDeliveryLiteDto> selectByWebhookUuid(DbSession dbSession, String webhookUuid, int offset, int limit) {
        return WebhookDeliveryDao.mapper(dbSession).selectByWebhookUuid(webhookUuid, new RowBounds(offset, limit));
    }

    public int countDeliveriesByComponentUuid(DbSession dbSession, String componentUuid) {
        return WebhookDeliveryDao.mapper(dbSession).countByComponentUuid(componentUuid);
    }

    public List<WebhookDeliveryLiteDto> selectOrderedByComponentUuid(DbSession dbSession, String componentUuid, int offset, int limit) {
        return WebhookDeliveryDao.mapper(dbSession).selectOrderedByComponentUuid(componentUuid, new RowBounds(offset, limit));
    }

    public int countDeliveriesByCeTaskUuid(DbSession dbSession, String ceTaskId) {
        return WebhookDeliveryDao.mapper(dbSession).countByCeTaskUuid(ceTaskId);
    }

    public List<WebhookDeliveryLiteDto> selectOrderedByCeTaskUuid(DbSession dbSession, String ceTaskUuid, int offset, int limit) {
        return WebhookDeliveryDao.mapper(dbSession).selectOrderedByCeTaskUuid(ceTaskUuid, new RowBounds(offset, limit));
    }

    public void insert(DbSession dbSession, WebhookDeliveryDto dto) {
        WebhookDeliveryDao.mapper(dbSession).insert(dto);
    }

    public void deleteComponentBeforeDate(DbSession dbSession, String componentUuid, long beforeDate) {
        WebhookDeliveryDao.mapper(dbSession).deleteComponentBeforeDate(componentUuid, beforeDate);
    }

    public Map<String, WebhookDeliveryLiteDto> selectLatestDeliveries(DbSession dbSession, List<WebhookDto> webhooks) {
        return webhooks.stream().flatMap(webhook -> this.selectByWebhookUuid(dbSession, webhook.getUuid(), 0, 1).stream()).collect(Collectors.toMap(WebhookDeliveryLiteDto::getWebhookUuid, Function.identity()));
    }

    private static WebhookDeliveryMapper mapper(DbSession dbSession) {
        return (WebhookDeliveryMapper)dbSession.getMapper(WebhookDeliveryMapper.class);
    }

    public void deleteByWebhook(DbSession dbSession, WebhookDto webhook) {
        WebhookDeliveryDao.mapper(dbSession).deleteByWebhookUuid(webhook.getUuid());
    }
}

