/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.scheduler;

import com.hazelcast.spi.TaskScheduler;
import com.hazelcast.util.Clock;
import com.hazelcast.util.scheduler.CompositeKey;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class SecondsBasedEntryTaskScheduler<K, V>
implements EntryTaskScheduler<K, V> {
    public static final int INITIAL_CAPACITY = 10;
    public static final double FACTOR = 1000.0;
    private static final long INITIAL_TIME_MILLIS = Clock.currentTimeMillis();
    private static final Comparator<ScheduledEntry> SCHEDULED_ENTRIES_COMPARATOR = new Comparator<ScheduledEntry>(){

        @Override
        public int compare(ScheduledEntry o1, ScheduledEntry o2) {
            if (o1.getScheduleId() > o2.getScheduleId()) {
                return 1;
            }
            if (o1.getScheduleId() < o2.getScheduleId()) {
                return -1;
            }
            return 0;
        }
    };
    private final Map<Object, Integer> secondsOfKeys = new HashMap<Object, Integer>(1000);
    private final Map<Integer, Map<Object, ScheduledEntry<K, V>>> scheduledEntries = new HashMap<Integer, Map<Object, ScheduledEntry<K, V>>>(1000);
    private final Map<Integer, ScheduledFuture> scheduledTaskMap = new HashMap<Integer, ScheduledFuture>(1000);
    private final AtomicLong uniqueIdGenerator = new AtomicLong();
    private final Object mutex = new Object();
    private final TaskScheduler taskScheduler;
    private final ScheduledEntryProcessor<K, V> entryProcessor;
    private final ScheduleType scheduleType;

    SecondsBasedEntryTaskScheduler(TaskScheduler taskScheduler, ScheduledEntryProcessor<K, V> entryProcessor, ScheduleType scheduleType) {
        this.taskScheduler = taskScheduler;
        this.entryProcessor = entryProcessor;
        this.scheduleType = scheduleType;
    }

    @Override
    public boolean schedule(long delayMillis, K key, V value) {
        if (this.scheduleType.equals((Object)ScheduleType.POSTPONE)) {
            return this.schedulePostponeEntry(delayMillis, key, value);
        }
        if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
            return this.scheduleEntry(delayMillis, key, value);
        }
        throw new RuntimeException("Undefined schedule type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedulePostponeEntry(long delayMillis, K key, V value) {
        int delaySeconds = SecondsBasedEntryTaskScheduler.ceilToSecond(delayMillis);
        Integer newSecond = SecondsBasedEntryTaskScheduler.findRelativeSecond(delayMillis);
        Object object = this.mutex;
        synchronized (object) {
            Integer existingSecond = this.secondsOfKeys.put(key, newSecond);
            if (existingSecond != null) {
                if (existingSecond.equals(newSecond)) {
                    return false;
                }
                this.removeKeyFromSecond(key, existingSecond);
            }
            long id = this.uniqueIdGenerator.incrementAndGet();
            ScheduledEntry<K, V> scheduledEntry = new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds, id);
            this.doSchedule(key, scheduledEntry, newSecond);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleEntry(long delayMillis, K key, V value) {
        int delaySeconds = SecondsBasedEntryTaskScheduler.ceilToSecond(delayMillis);
        Integer newSecond = SecondsBasedEntryTaskScheduler.findRelativeSecond(delayMillis);
        Object object = this.mutex;
        synchronized (object) {
            long id = this.uniqueIdGenerator.incrementAndGet();
            CompositeKey compositeKey = new CompositeKey(key, id);
            this.secondsOfKeys.put(compositeKey, newSecond);
            ScheduledEntry<K, V> scheduledEntry = new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds, id);
            this.doSchedule(compositeKey, scheduledEntry, newSecond);
        }
        return true;
    }

    private void doSchedule(Object mapKey, ScheduledEntry<K, V> entry, Integer second) {
        Map<Object, ScheduledEntry<Object, ScheduledEntry<K, V>>> entries = this.scheduledEntries.get(second);
        boolean shouldSchedule = false;
        if (entries == null) {
            entries = new HashMap<Object, ScheduledEntry<K, V>>(10);
            this.scheduledEntries.put(second, entries);
            shouldSchedule = true;
        }
        entries.put(mapKey, entry);
        if (shouldSchedule) {
            this.schedule(second, entry.getActualDelaySeconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledEntry<K, V> cancel(K key) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
                return this.cancelByCompositeKey(key);
            }
            Integer second = this.secondsOfKeys.remove(key);
            if (second == null) {
                return null;
            }
            Map<Object, ScheduledEntry<K, V>> entries = this.scheduledEntries.get(second);
            if (entries == null) {
                return null;
            }
            return this.cancelAndCleanUpIfEmpty(second, entries, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelIfExists(K key, V value) {
        Object object = this.mutex;
        synchronized (object) {
            ScheduledEntry<K, V> scheduledEntry = new ScheduledEntry<K, V>(key, value, 0L, 0, 0L);
            if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
                return this.cancelByCompositeKey(key, scheduledEntry);
            }
            Integer second = this.secondsOfKeys.remove(key);
            if (second == null) {
                return 0;
            }
            Map<Object, ScheduledEntry<K, V>> entries = this.scheduledEntries.get(second);
            if (entries == null) {
                return 0;
            }
            return this.cancelAndCleanUpIfEmpty(second, entries, key, scheduledEntry) ? 1 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledEntry<K, V> get(K key) {
        Object object = this.mutex;
        synchronized (object) {
            Map<Object, ScheduledEntry<K, V>> entries;
            if (this.scheduleType.equals((Object)ScheduleType.FOR_EACH)) {
                return this.getByCompositeKey(key);
            }
            Integer second = this.secondsOfKeys.get(key);
            if (second != null && (entries = this.scheduledEntries.get(second)) != null) {
                return entries.get(key);
            }
            return null;
        }
    }

    private ScheduledEntry<K, V> cancelByCompositeKey(K key) {
        Set<CompositeKey> candidateKeys = this.getCompositeKeys(key);
        ScheduledEntry<K, V> result = null;
        for (CompositeKey compositeKey : candidateKeys) {
            Map<Object, ScheduledEntry<K, V>> entries;
            Integer second = this.secondsOfKeys.remove(compositeKey);
            if (second == null || (entries = this.scheduledEntries.get(second)) == null) continue;
            result = this.cancelAndCleanUpIfEmpty(second, entries, compositeKey);
        }
        return result;
    }

    private int cancelByCompositeKey(K key, ScheduledEntry<K, V> entryToRemove) {
        int cancelled = 0;
        for (CompositeKey compositeKey : this.getCompositeKeys(key)) {
            Map<Object, ScheduledEntry<K, V>> entries;
            Integer second = this.secondsOfKeys.remove(compositeKey);
            if (second == null || (entries = this.scheduledEntries.get(second)) == null || !this.cancelAndCleanUpIfEmpty(second, entries, compositeKey, entryToRemove)) continue;
            ++cancelled;
        }
        return cancelled;
    }

    private Set<CompositeKey> getCompositeKeys(K key) {
        HashSet<CompositeKey> candidateKeys = new HashSet<CompositeKey>();
        for (Object keyObj : this.secondsOfKeys.keySet()) {
            CompositeKey compositeKey = (CompositeKey)keyObj;
            if (!compositeKey.getKey().equals(key)) continue;
            candidateKeys.add(compositeKey);
        }
        return candidateKeys;
    }

    public ScheduledEntry<K, V> getByCompositeKey(K key) {
        Set<CompositeKey> candidateKeys = this.getCompositeKeys(key);
        ScheduledEntry<K, V> result = null;
        for (CompositeKey compositeKey : candidateKeys) {
            Map<Object, ScheduledEntry<K, V>> entries;
            Integer second = this.secondsOfKeys.get(compositeKey);
            if (second == null || (entries = this.scheduledEntries.get(second)) == null) continue;
            result = entries.get(compositeKey);
        }
        return result;
    }

    private void removeKeyFromSecond(Object key, Integer existingSecond) {
        Map<Object, ScheduledEntry<K, V>> scheduledKeys = this.scheduledEntries.get(existingSecond);
        if (scheduledKeys != null) {
            this.cancelAndCleanUpIfEmpty(existingSecond, scheduledKeys, key);
        }
    }

    private ScheduledEntry<K, V> cancelAndCleanUpIfEmpty(Integer second, Map<Object, ScheduledEntry<K, V>> entries, Object key) {
        ScheduledEntry<K, V> result = entries.remove(key);
        this.cleanUpScheduledFuturesIfEmpty(second, entries);
        return result;
    }

    private boolean cancelAndCleanUpIfEmpty(Integer second, Map<Object, ScheduledEntry<K, V>> entries, Object key, ScheduledEntry<K, V> entryToRemove) {
        ScheduledEntry<K, V> entry = entries.get(key);
        if (entry == null || !entry.equals(entryToRemove)) {
            return false;
        }
        entries.remove(key);
        this.cleanUpScheduledFuturesIfEmpty(second, entries);
        return true;
    }

    private void cleanUpScheduledFuturesIfEmpty(Integer second, Map<Object, ScheduledEntry<K, V>> entries) {
        if (entries.isEmpty()) {
            this.scheduledEntries.remove(second);
            ScheduledFuture removedFeature = this.scheduledTaskMap.remove(second);
            if (removedFeature != null) {
                removedFeature.cancel(false);
            }
        }
    }

    private void schedule(Integer second, int delaySeconds) {
        EntryProcessorExecutor command = new EntryProcessorExecutor(second);
        ScheduledFuture<?> scheduledFuture = this.taskScheduler.schedule(command, (long)delaySeconds, TimeUnit.SECONDS);
        this.scheduledTaskMap.put(second, scheduledFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        Object object = this.mutex;
        synchronized (object) {
            this.secondsOfKeys.clear();
            this.scheduledEntries.clear();
            for (ScheduledFuture task : this.scheduledTaskMap.values()) {
                task.cancel(false);
            }
            this.scheduledTaskMap.clear();
        }
    }

    public String toString() {
        return "EntryTaskScheduler{secondsOfKeys=" + this.secondsOfKeys.size() + ", scheduledEntries [" + this.scheduledEntries.size() + "] =" + this.scheduledEntries.keySet() + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.secondsOfKeys.size();
        }
    }

    static int findRelativeSecond(long delayMillis) {
        long now = Clock.currentTimeMillis();
        long d = now + delayMillis - INITIAL_TIME_MILLIS;
        return SecondsBasedEntryTaskScheduler.ceilToSecond(d);
    }

    private static int ceilToSecond(long delayMillis) {
        return (int)Math.ceil((double)delayMillis / 1000.0);
    }

    private static <K, V> List<ScheduledEntry<K, V>> sortForEntryProcessing(List<ScheduledEntry<K, V>> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(coll, SCHEDULED_ENTRIES_COMPARATOR);
        return coll;
    }

    private final class EntryProcessorExecutor
    implements Runnable {
        private final Integer second;

        private EntryProcessorExecutor(Integer second) {
            this.second = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList values;
            Object object = SecondsBasedEntryTaskScheduler.this.mutex;
            synchronized (object) {
                SecondsBasedEntryTaskScheduler.this.scheduledTaskMap.remove(this.second);
                Map entries = (Map)SecondsBasedEntryTaskScheduler.this.scheduledEntries.remove(this.second);
                if (entries == null || entries.isEmpty()) {
                    return;
                }
                values = new ArrayList(entries.size());
                for (Map.Entry entry : entries.entrySet()) {
                    Integer removed = (Integer)SecondsBasedEntryTaskScheduler.this.secondsOfKeys.remove(entry.getKey());
                    if (removed == null) continue;
                    values.add(entry.getValue());
                }
            }
            SecondsBasedEntryTaskScheduler.this.entryProcessor.process(SecondsBasedEntryTaskScheduler.this, SecondsBasedEntryTaskScheduler.sortForEntryProcessing(values));
        }
    }
}

