/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import org.sonar.application.config.AppSettings;
import org.sonar.process.ProcessId;
import org.sonar.process.logging.LogLevelConfig;
import org.sonar.process.logging.LogbackHelper;
import org.sonar.process.logging.PatternLayoutEncoder;
import org.sonar.process.logging.RootLoggerConfig;

public class AppLogging {
    private static final String CONSOLE_LOGGER = "console";
    private static final String CONSOLE_PLAIN_APPENDER = "CONSOLE";
    private static final String APP_CONSOLE_APPENDER = "APP_CONSOLE";
    private static final String GOBBLER_PLAIN_CONSOLE = "GOBBLER_CONSOLE";
    private static final RootLoggerConfig APP_ROOT_LOGGER_CONFIG = RootLoggerConfig.newRootLoggerConfigBuilder().setProcessId(ProcessId.APP).build();
    private final LogbackHelper helper = new LogbackHelper();
    private final AppSettings appSettings;

    public AppLogging(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public LoggerContext configure() {
        LoggerContext ctx = this.helper.getRootContext();
        ctx.reset();
        this.helper.enableJulChangePropagation(ctx);
        this.configureConsole(ctx);
        if (this.helper.isAllLogsToConsoleEnabled(this.appSettings.getProps()) || !this.appSettings.getProps().valueAsBoolean("sonar.wrapped", false)) {
            this.configureWithLogbackWritingToFile(ctx);
        } else {
            this.configureWithWrapperWritingToFile(ctx);
        }
        this.helper.apply(LogLevelConfig.newBuilder((String)this.helper.getRootLoggerName()).rootLevelFor(ProcessId.APP).immutableLevel("com.hazelcast", Level.toLevel((String)"WARN")).build(), this.appSettings.getProps());
        return ctx;
    }

    private void configureConsole(LoggerContext loggerContext) {
        Encoder<ILoggingEvent> encoder = AppLogging.createGobblerEncoder(loggerContext);
        ConsoleAppender consoleAppender = this.helper.newConsoleAppender((Context)loggerContext, CONSOLE_PLAIN_APPENDER, encoder);
        Logger consoleLogger = loggerContext.getLogger(CONSOLE_LOGGER);
        consoleLogger.setAdditive(false);
        consoleLogger.addAppender((Appender)consoleAppender);
    }

    private void configureWithLogbackWritingToFile(LoggerContext ctx) {
        this.configureRootWithLogbackWritingToFile(ctx);
        this.configureGobbler(ctx);
    }

    private void configureWithWrapperWritingToFile(LoggerContext ctx) {
        Logger rootLogger = ctx.getLogger("ROOT");
        Encoder encoder = this.helper.createEncoder(this.appSettings.getProps(), APP_ROOT_LOGGER_CONFIG, ctx);
        rootLogger.addAppender(this.createAppConsoleAppender(ctx, (Encoder<ILoggingEvent>)encoder));
        this.configureGobbler(ctx);
    }

    private void configureRootWithLogbackWritingToFile(LoggerContext ctx) {
        Logger rootLogger = ctx.getLogger("ROOT");
        Encoder encoder = this.helper.createEncoder(this.appSettings.getProps(), APP_ROOT_LOGGER_CONFIG, ctx);
        FileAppender fileAppender = this.helper.newFileAppender(ctx, this.appSettings.getProps(), APP_ROOT_LOGGER_CONFIG, encoder);
        rootLogger.addAppender((Appender)fileAppender);
        rootLogger.addAppender(this.createAppConsoleAppender(ctx, (Encoder<ILoggingEvent>)encoder));
    }

    private void configureGobbler(LoggerContext ctx) {
        Logger gobblerLogger = ctx.getLogger("gobbler");
        gobblerLogger.setAdditive(false);
        Encoder<ILoggingEvent> encoder = AppLogging.createGobblerEncoder(ctx);
        gobblerLogger.addAppender((Appender)this.helper.newConsoleAppender((Context)ctx, GOBBLER_PLAIN_CONSOLE, encoder));
    }

    private ConsoleAppender<ILoggingEvent> createAppConsoleAppender(LoggerContext ctx, Encoder<ILoggingEvent> encoder) {
        return this.helper.newConsoleAppender((Context)ctx, APP_CONSOLE_APPENDER, encoder);
    }

    private static Encoder<ILoggingEvent> createGobblerEncoder(LoggerContext context) {
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern("%msg%n");
        encoder.start();
        return encoder;
    }
}

