/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.cluster;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.nio.Address;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.application.config.AppSettings;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.cluster.hz.DistributedCallback;
import org.sonar.process.cluster.hz.HazelcastMember;
import org.sonar.process.cluster.hz.HazelcastMemberSelectors;

public class AppNodesClusterHostsConsistency {
    private static final Logger LOG = LoggerFactory.getLogger(AppNodesClusterHostsConsistency.class);
    private static final AtomicReference<AppNodesClusterHostsConsistency> INSTANCE = new AtomicReference();
    private final AppSettings settings;
    private final HazelcastMember hzMember;
    private final Consumer<String> logger;

    private AppNodesClusterHostsConsistency(HazelcastMember hzMember, AppSettings settings, Consumer<String> logger) {
        this.hzMember = hzMember;
        this.settings = settings;
        this.logger = logger;
    }

    public static AppNodesClusterHostsConsistency setInstance(HazelcastMember hzMember, AppSettings settings) {
        return AppNodesClusterHostsConsistency.setInstance(hzMember, settings, arg_0 -> ((Logger)LOG).warn(arg_0));
    }

    @VisibleForTesting
    public static AppNodesClusterHostsConsistency setInstance(HazelcastMember hzMember, AppSettings settings, Consumer<String> logger) {
        AppNodesClusterHostsConsistency instance = new AppNodesClusterHostsConsistency(hzMember, settings, logger);
        Preconditions.checkState((boolean)INSTANCE.compareAndSet(null, instance), (Object)"Instance is already set");
        return instance;
    }

    @CheckForNull
    @VisibleForTesting
    protected static AppNodesClusterHostsConsistency clearInstance() {
        return INSTANCE.getAndSet(null);
    }

    public void check() {
        try {
            MemberSelector selector = MemberSelectors.and((MemberSelector[])new MemberSelector[]{MemberSelectors.NON_LOCAL_MEMBER_SELECTOR, HazelcastMemberSelectors.selectorForProcessIds((ProcessId[])new ProcessId[]{ProcessId.APP})});
            this.hzMember.callAsync(AppNodesClusterHostsConsistency::getConfiguredClusterHosts, selector, (DistributedCallback)new Callback());
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private static List<String> getConfiguredClusterHosts() {
        try {
            AppNodesClusterHostsConsistency instance = INSTANCE.get();
            if (instance != null) {
                return Arrays.asList(instance.settings.getProps().nonNullValue(ProcessProperties.Property.CLUSTER_HZ_HOSTS.getKey()).split(","));
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error("Failed to get configured cluster nodes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private class Callback
    implements DistributedCallback<List<String>> {
        private Callback() {
        }

        public void onComplete(Map<Member, List<String>> hostsPerMember) {
            List currentConfiguredHosts = AppNodesClusterHostsConsistency.getConfiguredClusterHosts();
            boolean anyDifference = hostsPerMember.values().stream().filter(v -> !v.isEmpty()).anyMatch(hosts -> currentConfiguredHosts.size() != hosts.size() || !currentConfiguredHosts.containsAll((Collection<?>)hosts));
            if (anyDifference) {
                StringBuilder builder = new StringBuilder().append("The configuration of the current node doesn't match the list of hosts configured in the application nodes that have already joined the cluster:\n");
                this.logMemberSetting(builder, AppNodesClusterHostsConsistency.this.hzMember.getCluster().getLocalMember(), currentConfiguredHosts);
                for (Map.Entry<Member, List<String>> e : hostsPerMember.entrySet()) {
                    if (e.getValue().isEmpty()) continue;
                    this.logMemberSetting(builder, e.getKey(), e.getValue());
                }
                builder.append("Make sure the configuration is consistent among all application nodes before you restart any node");
                AppNodesClusterHostsConsistency.this.logger.accept(builder.toString());
            }
        }

        private String toString(Address address) {
            return address.getHost() + ":" + address.getPort();
        }

        private void logMemberSetting(StringBuilder builder, Member member, List<String> configuredHosts) {
            builder.append(this.toString(member.getAddress()));
            builder.append(" : ");
            builder.append(configuredHosts);
            if (member.localMember()) {
                builder.append(" (current)");
            }
            builder.append("\n");
        }
    }
}

