/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

public class Issue {
    private final Check check;
    private final Message primaryMessage;
    private final Message[] secondaryMessages;
    @Nullable
    private final Double effortToFix;

    public Issue(Check check, Message primaryMessage, @Nullable Double effortToFix, Message ... secondaryMessages) {
        this.check = check;
        this.primaryMessage = primaryMessage;
        this.effortToFix = effortToFix;
        this.secondaryMessages = secondaryMessages;
    }

    public static Issue issueOnFile(Check check, String message) {
        return new Issue(check, new Message(null, message), null, new Message[0]);
    }

    public static Issue issueOnLine(Check check, int line, String message) {
        return new Issue(check, new Message(line, message), null, new Message[0]);
    }

    public Check getCheck() {
        return this.check;
    }

    public boolean hasNodeLocation() {
        return this.primaryMessage.from != null;
    }

    public boolean hasLineLocation() {
        return this.primaryMessage.line != null;
    }

    public String getMessage() {
        return this.primaryMessage.description;
    }

    public Message getPrimary() {
        return this.primaryMessage;
    }

    public Message[] getSecondaries() {
        return this.secondaryMessages;
    }

    @Nullable
    public Double getEffortToFix() {
        return this.effortToFix;
    }

    public String toString() {
        return this.check.getClass().getSimpleName() + ": " + this.primaryMessage.toString() + " " + Arrays.stream(this.secondaryMessages).map(Message::toString).collect(Collectors.joining(" "));
    }

    public static class Message {
        @Nullable
        public final UastNode from;
        @Nullable
        public final UastNode to;
        @Nullable
        public final Integer line;
        @Nullable
        public final String description;

        public Message(UastNode node) {
            this(node, node, null);
        }

        public Message(@Nullable UastNode node, @Nullable String description) {
            this(node, node, description);
        }

        public Message(@Nullable UastNode from, @Nullable UastNode to, @Nullable String description) {
            this.from = from;
            this.to = to;
            this.description = description;
            this.line = null;
        }

        public Message(int line, String message) {
            this.from = null;
            this.to = null;
            this.description = message;
            this.line = line;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            if (this.from != null) {
                text.append("(");
                text.append(this.from.firstToken());
                text.append(", ");
                text.append(this.to.lastToken());
                text.append(")");
            }
            if (this.description != null) {
                text.append(" ").append(this.description);
            }
            return text.toString();
        }
    }
}

