/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.CognitiveComplexity;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.FunctionLike;

@Rule(key="S3776")
public class FunctionCognitiveComplexityCheck
extends Check {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 15;
    private int nestedFunctionLevel;
    @RuleProperty(key="maximumFunctionCognitiveComplexityThreshold", description="The maximum authorized complexity.", defaultValue="15")
    private int maxComplexity = 15;

    public FunctionCognitiveComplexityCheck() {
        super(UastNode.Kind.FUNCTION);
    }

    @Override
    public void enterFile(InputFile inputFile) {
        this.nestedFunctionLevel = 0;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    @Override
    public void visitNode(UastNode node) {
        ++this.nestedFunctionLevel;
        if (this.nestedFunctionLevel != 1) {
            return;
        }
        FunctionLike functionNode = FunctionLike.from(node);
        if (functionNode == null) {
            return;
        }
        CognitiveComplexity complexity = CognitiveComplexity.calculateFunctionComplexity(functionNode.node());
        if (complexity.value() > this.maxComplexity) {
            String message = "Refactor this function to reduce its Cognitive Complexity from " + complexity.value() + " to the " + this.maxComplexity + " allowed.";
            int effortToFix = complexity.value() - this.maxComplexity;
            this.reportIssue(functionNode.name(), functionNode.name(), message, effortToFix, complexity.secondaryLocations());
        }
    }

    @Override
    public void leaveNode(UastNode node) {
        --this.nestedFunctionLevel;
    }
}

