/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.GoPathContext;

public final class GoCoverageReport {
    private static final Logger LOG = Loggers.get(GoCoverageReport.class);
    public static final String REPORT_PATH_KEY = "sonar.go.coverage.reportPaths";
    static final Pattern MODE_LINE_REGEXP = Pattern.compile("^mode: (\\w+)$");
    static final Pattern COVERAGE_LINE_REGEXP = Pattern.compile("^(.+):(\\d+)\\.(\\d+),(\\d+)\\.(\\d+) (\\d+) (\\d+)$");

    private GoCoverageReport() {
    }

    public static void saveCoverageReports(SensorContext sensorContext, GoPathContext goContext) {
        Coverage coverage = new Coverage(goContext);
        GoCoverageReport.getReportPaths(sensorContext).forEach(reportPath -> GoCoverageReport.parse(reportPath, coverage));
        coverage.fileMap.forEach((filePath, coverageStats) -> {
            try {
                GoCoverageReport.saveFileCoverage(sensorContext, filePath, coverageStats);
            }
            catch (Exception e) {
                LOG.error("Error saving coverage info for file " + filePath, (Throwable)e);
            }
        });
    }

    private static void saveFileCoverage(SensorContext sensorContext, String filePath, List<CoverageStat> coverageStats) throws IOException {
        FileSystem fileSystem = sensorContext.fileSystem();
        InputFile inputFile = GoCoverageReport.findInputFile(filePath, fileSystem);
        if (inputFile != null) {
            LOG.debug("Saving coverage measures for file '{}'", (Object)filePath);
            List<String> lines = Arrays.asList(inputFile.contents().split("\\r?\\n"));
            NewCoverage newCoverage = sensorContext.newCoverage().onFile(inputFile);
            FileCoverage fileCoverage = new FileCoverage(coverageStats, lines);
            for (Map.Entry<Integer, LineCoverage> entry : fileCoverage.lineMap.entrySet()) {
                newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().hits);
            }
            newCoverage.save();
        } else {
            LOG.warn("File '{}' is not included in the project, ignoring coverage", (Object)filePath);
        }
    }

    private static InputFile findInputFile(String absolutePath, FileSystem fileSystem) {
        FilePredicates predicates = fileSystem.predicates();
        InputFile inputFile = fileSystem.inputFile(predicates.hasAbsolutePath(absolutePath));
        if (inputFile != null) {
            return inputFile;
        }
        LOG.debug("Resolving file {} using relative path", (Object)absolutePath);
        Path path = Paths.get(absolutePath, new String[0]);
        inputFile = fileSystem.inputFile(predicates.hasRelativePath(path.toString()));
        while (inputFile == null && path.getNameCount() > 1) {
            path = path.subpath(1, path.getNameCount());
            inputFile = fileSystem.inputFile(predicates.hasRelativePath(path.toString()));
        }
        return inputFile;
    }

    static Stream<Path> getReportPaths(SensorContext sensorContext) {
        Configuration config = sensorContext.config();
        Path baseDir = sensorContext.fileSystem().baseDir().toPath();
        String[] reportPaths = config.getStringArray(REPORT_PATH_KEY);
        return Arrays.stream(reportPaths).flatMap(reportPath -> GoCoverageReport.isWildcard(reportPath) ? GoCoverageReport.getPatternPaths(baseDir, reportPath) : GoCoverageReport.getRegularPath(baseDir, reportPath));
    }

    private static Stream<Path> getRegularPath(Path baseDir, String reportPath) {
        Path path = Paths.get(reportPath, new String[0]);
        if (!path.isAbsolute()) {
            path = baseDir.resolve(path);
        }
        if (path.toFile().exists()) {
            return Stream.of(path);
        }
        LOG.error("Coverage report can't be loaded, report file not found, ignoring this file {}.", (Object)reportPath);
        return Stream.empty();
    }

    private static boolean isWildcard(String path) {
        return path.contains("*") || path.contains("?");
    }

    private static Stream<Path> getPatternPaths(Path baseDir, String reportPath) {
        Stream<Path> stream;
        block8: {
            Stream<Path> paths = Files.walk(baseDir, 999, new FileVisitOption[0]);
            try {
                stream = GoCoverageReport.findMatchingPaths(baseDir, reportPath, paths);
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error finding coverage files using pattern {}", (Object)reportPath);
                    return Stream.empty();
                }
            }
            paths.close();
        }
        return stream;
    }

    private static String toUnixLikePath(String path) {
        return path.replace('\\', '/');
    }

    private static Stream<Path> findMatchingPaths(Path baseDir, String reportPath, Stream<Path> paths) {
        WildcardPattern globPattern = WildcardPattern.create((String)GoCoverageReport.toUnixLikePath(reportPath));
        List matchingPaths = paths.filter(currentPath -> {
            Path normalizedPath = baseDir.toAbsolutePath().relativize(currentPath.toAbsolutePath());
            String pathToMatch = GoCoverageReport.toUnixLikePath(normalizedPath.toString());
            return globPattern.match(pathToMatch);
        }).collect(Collectors.toList());
        if (matchingPaths.isEmpty()) {
            LOG.error("Coverage report can't be loaded, file(s) not found for pattern: '{}', ignoring this file.", (Object)reportPath);
        }
        return matchingPaths.stream();
    }

    static void parse(Path reportPath, Coverage coverage) {
        LOG.info("Load coverage report from '{}'", (Object)reportPath);
        try (FileInputStream input = new FileInputStream(reportPath.toFile());){
            Scanner scanner = new Scanner((InputStream)input, StandardCharsets.UTF_8.name());
            if (!scanner.hasNextLine() || !MODE_LINE_REGEXP.matcher(scanner.nextLine()).matches()) {
                throw new IOException("Invalid go coverage, expect 'mode:' on the first line.");
            }
            int lineNumber = 2;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.isEmpty()) {
                    coverage.add(new CoverageStat(lineNumber, line));
                }
                ++lineNumber;
            }
        }
        catch (IOException e) {
            LOG.error("Error parsing coverage info for file {}: {}", (Object)reportPath, (Object)e.getMessage());
        }
    }

    static class CoverageStat {
        final String filePath;
        final int startLine;
        final int startCol;
        final int endLine;
        final int endCol;
        final int numStmt;
        final int count;

        CoverageStat(int lineNumber, String line) {
            Matcher matcher = COVERAGE_LINE_REGEXP.matcher(line);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid go coverage at line " + lineNumber);
            }
            this.filePath = matcher.group(1);
            this.startLine = Integer.parseInt(matcher.group(2));
            this.startCol = Integer.parseInt(matcher.group(3));
            this.endLine = Integer.parseInt(matcher.group(4));
            this.endCol = Integer.parseInt(matcher.group(5));
            this.numStmt = Integer.parseInt(matcher.group(6));
            this.count = Integer.parseInt(matcher.group(7));
        }
    }

    static class LineCoverage {
        int hits = 0;

        LineCoverage() {
        }

        void add(CoverageStat coverage) {
            this.hits += coverage.count;
        }
    }

    static class FileCoverage {
        Map<Integer, LineCoverage> lineMap = new HashMap<Integer, LineCoverage>();
        List<String> lines;

        public FileCoverage(List<CoverageStat> coverageStats, @Nullable List<String> lines) {
            this.lines = lines;
            coverageStats.forEach(this::add);
        }

        private void add(CoverageStat coverage) {
            int startLine = this.findStartIgnoringBrace(coverage);
            int endLine = this.findEndIgnoringBrace(coverage, startLine);
            for (int line = startLine; line <= endLine; ++line) {
                this.lineMap.computeIfAbsent(line, key -> new LineCoverage()).add(coverage);
            }
        }

        int findStartIgnoringBrace(CoverageStat coverage) {
            int line = coverage.startLine;
            int column = coverage.startCol;
            while (this.shouldIgnore(line, column)) {
                if (++column <= this.lines.get(line - 1).length()) continue;
                ++line;
                column = 1;
            }
            return line;
        }

        int findEndIgnoringBrace(CoverageStat coverage, int startLine) {
            int line = coverage.endLine;
            int column = coverage.endCol - 1;
            if (this.lines != null && line > this.lines.size()) {
                line = this.lines.size();
                column = this.lines.get(line - 1).length();
            }
            while (line > startLine && this.shouldIgnore(line, column)) {
                if (--column != 0) continue;
                column = this.lines.get(--line - 1).length();
            }
            return line;
        }

        boolean shouldIgnore(int line, int column) {
            if (this.lines != null && line > 0 && line <= this.lines.size() && column > 0 && column <= this.lines.get(line - 1).length()) {
                char ch = this.lines.get(line - 1).charAt(column - 1);
                return ch < ' ' || ch == '{' || ch == '}';
            }
            return false;
        }
    }

    static class Coverage {
        final GoPathContext goContext;
        Map<String, List<CoverageStat>> fileMap = new HashMap<String, List<CoverageStat>>();

        Coverage(GoPathContext goContext) {
            this.goContext = goContext;
        }

        void add(CoverageStat coverage) {
            this.fileMap.computeIfAbsent(this.goContext.resolve(coverage.filePath), key -> new ArrayList()).add(coverage);
        }
    }
}

