/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.go.plugin.GoPathContext;

public class GoTestSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(GoTestSensor.class);
    public static final String REPORT_PATH_KEY = "sonar.go.tests.reportPaths";
    private static final Gson GSON = new Gson();
    GoPathContext goPathContext = GoPathContext.DEFAULT;
    private Map<String, List<InputFile>> testFilesByPackage = new HashMap<String, List<InputFile>>();

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("go").onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PATH_KEY)).name("Go Unit Test Report");
    }

    public void execute(SensorContext context) {
        HashMap<InputFile, List> testInfoByFile = new HashMap<InputFile, List>();
        GoTestSensor.getReportPaths(context).forEach(path -> this.parseReport(context, (Path)path, (Map<InputFile, List<TestInfo>>)testInfoByFile));
        testInfoByFile.forEach((key, value) -> GoTestSensor.saveTestMetrics(context, key, value));
    }

    private static List<Path> getReportPaths(SensorContext context) {
        String[] reportPaths;
        ArrayList<Path> result = new ArrayList<Path>();
        for (String reportPath : reportPaths = context.config().getStringArray(REPORT_PATH_KEY)) {
            Path path = Paths.get(reportPath, new String[0]);
            if (!path.isAbsolute()) {
                path = context.fileSystem().baseDir().toPath().resolve(path);
            }
            if (path.toFile().exists()) {
                result.add(path);
                continue;
            }
            LOG.error("Test report can't be loaded, file not found: '{}', ignoring this file.", (Object)path);
        }
        return result;
    }

    private void parseReport(SensorContext context, Path reportPath, Map<InputFile, List<TestInfo>> testInfoByFile) {
        try {
            List testInfoList = Files.readAllLines(reportPath).stream().filter(line -> line.startsWith("{")).map(line -> GoTestSensor.getRelevantTestInfo(line, reportPath)).filter(Objects::nonNull).collect(Collectors.toList());
            for (TestInfo testInfo : testInfoList) {
                InputFile testFile = this.findTestFile(context.fileSystem(), testInfo);
                if (testFile != null) {
                    testInfoByFile.computeIfAbsent(testFile, key -> new ArrayList()).add(testInfo);
                    continue;
                }
                LOG.warn("Failed to find test file for package " + testInfo.Package + " and test " + testInfo.Test);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to read unit test report file " + reportPath.toString(), (Throwable)e);
        }
    }

    @Nullable
    private static TestInfo getRelevantTestInfo(String line, Path reportPath) {
        try {
            TestInfo testInfo = GSON.fromJson(line, TestInfo.class);
            if (testInfo.isRelevant()) {
                return testInfo;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse unit test report line (file " + reportPath + "):\n " + line);
        }
        return null;
    }

    @Nullable
    InputFile findTestFile(FileSystem fileSystem, TestInfo testInfo) throws IOException {
        List testInputFilesInPackage = this.testFilesByPackage.computeIfAbsent(testInfo.Package, goPackage -> this.getTestFilesForPackage(fileSystem, (String)goPackage));
        String testName = testInfo.Test.split("/", 2)[0];
        Pattern pattern = Pattern.compile("^func\\s+" + testName + "\\s*\\(", 8);
        for (InputFile testFile : testInputFilesInPackage) {
            if (!pattern.matcher(testFile.contents()).find()) continue;
            return testFile;
        }
        return null;
    }

    private List<InputFile> getTestFilesForPackage(FileSystem fileSystem, String goPackage) {
        List<InputFile> list;
        block9: {
            FilePredicates predicates = fileSystem.predicates();
            String packageDirectory = this.goPathContext.resolve(goPackage);
            if (!new File(packageDirectory).exists() && (packageDirectory = GoTestSensor.findPackageDirectory(goPackage, fileSystem)) == null) {
                return Collections.emptyList();
            }
            Stream<Path> stream = Files.list(Paths.get(packageDirectory, new String[0]));
            try {
                list = stream.map(path -> fileSystem.inputFile(GoTestSensor.testFilePredicate(predicates, path))).filter(Objects::nonNull).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Failed to read package directory " + packageDirectory, (Throwable)e);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    private static FilePredicate testFilePredicate(FilePredicates predicates, Path path) {
        return predicates.and(new FilePredicate[]{predicates.hasType(InputFile.Type.TEST), predicates.hasAbsolutePath(path.toString()), predicates.hasLanguage("go")});
    }

    private static String findPackageDirectory(String packagePath, FileSystem fileSystem) {
        File resolved = fileSystem.baseDir().toPath().resolve(packagePath).toFile();
        if (resolved.exists()) {
            return resolved.toString();
        }
        Path path = Paths.get(packagePath, new String[0]);
        if (path.getNameCount() == 1) {
            if (path.getName(0).toString().equals(fileSystem.baseDir().getName())) {
                return fileSystem.baseDir().toString();
            }
            return null;
        }
        Path subpath = path.subpath(1, path.getNameCount());
        return GoTestSensor.findPackageDirectory(subpath.toString(), fileSystem);
    }

    private static void saveTestMetrics(SensorContext context, InputFile testFile, List<TestInfo> tests) {
        int skip = 0;
        long timeMs = 0L;
        int fail = 0;
        for (TestInfo test : tests) {
            timeMs = (long)((double)timeMs + test.Elapsed * 1000.0);
            if (test.Action.equals("skip")) {
                ++skip;
                continue;
            }
            if (!test.Action.equals("fail")) continue;
            ++fail;
        }
        context.newMeasure().on((InputComponent)testFile).withValue((Serializable)Integer.valueOf(skip)).forMetric((Metric)CoreMetrics.SKIPPED_TESTS).save();
        context.newMeasure().on((InputComponent)testFile).withValue((Serializable)Long.valueOf(timeMs)).forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).save();
        context.newMeasure().on((InputComponent)testFile).withValue((Serializable)Integer.valueOf(tests.size())).forMetric((Metric)CoreMetrics.TESTS).save();
        context.newMeasure().on((InputComponent)testFile).withValue((Serializable)Integer.valueOf(fail)).forMetric((Metric)CoreMetrics.TEST_FAILURES).save();
    }

    static class TestInfo {
        String Action;
        String Package;
        String Test;
        Double Elapsed;

        TestInfo(String action, String aPackage, String test, Double elapsed) {
            this.Action = action;
            this.Package = aPackage;
            this.Test = test;
            this.Elapsed = elapsed;
        }

        boolean isRelevant() {
            return this.Action != null && this.Test != null && this.Package != null && this.Elapsed != null && (this.Action.equals("pass") || this.Action.equals("fail") || this.Action.equals("skip"));
        }
    }
}

