/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;

@Rule(key="S134")
public class ControlFlowStmtDepthCheck
extends FlexCheck {
    private int nestingLevel;
    private static final int DEFAULT_MAX = 3;
    @RuleProperty(key="max", description="Maximum allowed control flow statement nesting depth.", defaultValue="3")
    public int max = 3;

    public int getMax() {
        return this.max;
    }

    @Override
    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.IF_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT, FlexGrammar.SWITCH_STATEMENT);
    }

    @Override
    public void visitFile(@Nullable AstNode astNode) {
        this.nestingLevel = 0;
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (!ControlFlowStmtDepthCheck.isElseIf(astNode)) {
            ++this.nestingLevel;
            if (this.nestingLevel == this.getMax() + 1) {
                this.addIssue(MessageFormat.format("Refactor this code to not nest more than {0} if/for/while/switch statements.", this.getMax()), astNode);
            }
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (!ControlFlowStmtDepthCheck.isElseIf(astNode)) {
            --this.nestingLevel;
        }
    }

    private static boolean isElseIf(AstNode astNode) {
        return astNode.getParent().getParent().getPreviousSibling() != null && astNode.getParent().getParent().getPreviousSibling().is(FlexKeyword.ELSE);
    }
}

