/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.externalreport.rubocop;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.analyzer.commons.ExternalReportProvider;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopJsonReportReader;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopRulesDefinition;

public class RuboCopSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(RuboCopSensor.class);
    static final String LINTER_KEY = "rubocop";
    static final String LINTER_NAME = "RuboCop";
    public static final String REPORT_PROPERTY_KEY = "sonar.ruby.rubocop.reportPaths";
    private static final int MAX_LOGGED_FILE_NAMES = 20;

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(conf -> conf.hasKey(REPORT_PROPERTY_KEY)).name("Import of RuboCop issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, REPORT_PROPERTY_KEY);
        HashSet<String> unresolvedInputFile = new HashSet<String>();
        reportFiles.forEach(report -> RuboCopSensor.importReport(report, context, unresolvedInputFile));
        RuboCopSensor.logUnresolvedInputFiles(unresolvedInputFile);
    }

    private static void logUnresolvedInputFiles(Set<String> unresolvedInputFile) {
        if (unresolvedInputFile.isEmpty()) {
            return;
        }
        String fileList = unresolvedInputFile.stream().sorted().limit(20L).collect(Collectors.joining(";"));
        if (unresolvedInputFile.size() > 20) {
            fileList = fileList + ";...";
        }
        LOG.warn("Fail to resolve {} file(s). No RuboCop issues will be imported on the following file(s): {}", (Object)unresolvedInputFile.size(), (Object)fileList);
    }

    private static void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFile) {
        try (FileInputStream in = new FileInputStream(reportPath);){
            LOG.info("Importing {}", (Object)reportPath);
            RuboCopJsonReportReader.read(in, issue -> RuboCopSensor.saveIssue(context, issue, unresolvedInputFile));
        }
        catch (IOException | RuntimeException | ParseException e) {
            LOG.error("No issues information will be saved as the report file '{}' can't be read. " + e.getMessage(), (Object)reportPath, (Object)e);
        }
    }

    private static void saveIssue(SensorContext context, RuboCopJsonReportReader.Issue issue, Set<String> unresolvedInputFile) {
        if (RuboCopSensor.isEmpty(issue.ruleKey) || RuboCopSensor.isEmpty(issue.filePath) || RuboCopSensor.isEmpty(issue.message)) {
            LOG.debug("Missing information or unsupported file type for ruleKey:'{}', filePath:'{}', message:'{}'", new Object[]{issue.ruleKey, issue.filePath, issue.message});
            return;
        }
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.hasPath(issue.filePath));
        if (inputFile == null) {
            unresolvedInputFile.add(issue.filePath);
            return;
        }
        RuleKey qualifiedRuleKey = RuleKey.of((String)LINTER_KEY, (String)issue.ruleKey);
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        String ruleKey = qualifiedRuleKey.rule();
        ExternalRuleLoader externalRuleLoader = RuboCopRulesDefinition.RULE_LOADER;
        newExternalIssue.type(externalRuleLoader.ruleType(ruleKey)).severity(externalRuleLoader.ruleSeverity(ruleKey)).remediationEffortMinutes(externalRuleLoader.ruleConstantDebtMinutes(ruleKey));
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        if (issue.startLine != null) {
            boolean rangeIsValid;
            boolean rangeIsProvided = issue.startColumn != null && issue.lastLine != null && issue.lastColumn != null;
            boolean bl = rangeIsValid = rangeIsProvided && (issue.startLine < issue.lastLine || issue.startLine == issue.lastLine && issue.startColumn <= issue.lastColumn);
            if (rangeIsValid) {
                primaryLocation.at(inputFile.newRange(issue.startLine.intValue(), issue.startColumn - 1, issue.lastLine.intValue(), issue.lastColumn.intValue()));
            } else {
                primaryLocation.at(inputFile.selectLine(issue.startLine.intValue()));
            }
        }
        newExternalIssue.at(primaryLocation).forRule(qualifiedRuleKey).save();
    }

    private static boolean isEmpty(@Nullable String value2) {
        return value2 == null || value2.trim().isEmpty();
    }
}

