/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.ruby.plugin;

import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.Version;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopRulesDefinition;
import org.sonarsource.ruby.externalreport.rubocop.RuboCopSensor;
import org.sonarsource.ruby.plugin.RubyLanguage;
import org.sonarsource.ruby.plugin.RubyProfileDefinition;
import org.sonarsource.ruby.plugin.RubyRulesDefinition;
import org.sonarsource.ruby.plugin.RubySensor;
import org.sonarsource.ruby.plugin.SimpleCovSensor;

public class RubyPlugin
implements Plugin {
    public static final String RUBY_LANGUAGE_KEY = "ruby";
    static final String RUBY_LANGUAGE_NAME = "Ruby";
    static final String RUBY_FILE_SUFFIXES_DEFAULT_VALUE = ".rb";
    static final String RUBY_FILE_SUFFIXES_KEY = "sonar.ruby.file.suffixes";
    static final String REPORT_PATHS_DEFAULT_VALUE = "coverage/.resultset.json";
    static final String REPORT_PATHS_KEY = "sonar.ruby.coverage.reportPaths";
    static final String RUBY_REPOSITORY_KEY = "ruby";
    static final String REPOSITORY_NAME = "SonarAnalyzer";
    static final String PROFILE_NAME = "Sonar way";
    private static final String GENERAL = "General";
    private static final String RUBY_CATEGORY = "Ruby";
    private static final String TEST_COVERAGE_SUBCATEGORY = "Test and Coverage";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";

    public void define(Plugin.Context context) {
        context.addExtensions(RubyLanguage.class, RubySensor.class, new Object[]{RubyProfileDefinition.class, RubyRulesDefinition.class});
        boolean externalIssuesSupported = context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)7, (int)2));
        if (context.getRuntime().getProduct() != SonarProduct.SONARLINT) {
            context.addExtensions((Object)new RuboCopRulesDefinition(externalIssuesSupported), RuboCopSensor.class, new Object[]{SimpleCovSensor.class, PropertyDefinition.builder((String)RUBY_FILE_SUFFIXES_KEY).defaultValue(RUBY_FILE_SUFFIXES_DEFAULT_VALUE).name("File Suffixes").description("List of suffixes for files to analyze.").subCategory(GENERAL).category("Ruby").multiValues(true).onQualifiers("TRK", new String[0]).build(), PropertyDefinition.builder((String)REPORT_PATHS_KEY).defaultValue(REPORT_PATHS_DEFAULT_VALUE).name("Path to coverage report(s)").description("Path to coverage report files (.resultset.json) generated by SimpleCov. The path may be absolute or relative to the project base directory.").category("Ruby").subCategory(TEST_COVERAGE_SUBCATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build()});
            if (externalIssuesSupported) {
                context.addExtension((Object)PropertyDefinition.builder((String)"sonar.ruby.rubocop.reportPaths").name("RuboCop Report Files").description("Paths (absolute or relative) to json files with RuboCop issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory("Ruby").onQualifiers("TRK", new String[0]).multiValues(true).build());
            }
        }
    }
}

