/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1192")
public class StringLiteralDuplicatedCheck
implements SlangCheck {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final int MINIMAL_LITERAL_LENGTH = 5;
    private static final Pattern NO_SEPARATOR_REGEXP = Pattern.compile("\\w++");
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(TopLevelTree.class, (ctx, tree) -> {
            HashMap<String, List<StringLiteralTree>> occurrences = new HashMap<String, List<StringLiteralTree>>();
            tree.descendants().filter(StringLiteralTree.class::isInstance).map(StringLiteralTree.class::cast).filter(literal -> literal.content().length() > 5 && !NO_SEPARATOR_REGEXP.matcher(literal.content()).matches()).forEach(literal -> occurrences.computeIfAbsent(literal.content(), key2 -> new LinkedList()).add(literal));
            StringLiteralDuplicatedCheck.check(ctx, occurrences, this.threshold);
        });
    }

    private static void check(CheckContext ctx, Map<String, List<StringLiteralTree>> occurrencesMap, int threshold) {
        for (Map.Entry<String, List<StringLiteralTree>> entry : occurrencesMap.entrySet()) {
            List<StringLiteralTree> occurrences = entry.getValue();
            int size2 = occurrences.size();
            if (size2 < threshold) continue;
            StringLiteralTree first2 = occurrences.get(0);
            String message2 = String.format("Define a constant instead of duplicating this literal \"%s\" %s times.", first2.content(), size2);
            List<SecondaryLocation> secondaryLocations = occurrences.stream().skip(1L).map(stringLiteral -> new SecondaryLocation(stringLiteral.metaData().textRange(), "Duplication")).collect(Collectors.toList());
            double gap = (double)size2 - 1.0;
            ctx.reportIssue(first2, message2, secondaryLocations, gap);
        }
    }
}

