/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SecondaryLocation;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.checks.utils.FunctionUtils;
import org.sonarsource.slang.impl.TopLevelTreeImpl;
import org.sonarsource.slang.utils.SyntacticEquivalence;

@Rule(key="S1172")
public class UnusedFunctionParameterCheck
implements SlangCheck {
    private static final Pattern IGNORED_PATTERN = Pattern.compile("main", 2);

    @Override
    public void initialize(InitContext init) {
        init.register(FunctionDeclarationTree.class, (ctx, functionDeclarationTree) -> {
            if (functionDeclarationTree.isConstructor() || UnusedFunctionParameterCheck.shouldBeIgnored(ctx, functionDeclarationTree)) {
                return;
            }
            List unusedParameters = functionDeclarationTree.formalParameters().stream().filter(ParameterTree.class::isInstance).map(ParameterTree.class::cast).filter(parameterTree -> parameterTree.modifiers().isEmpty() && functionDeclarationTree.descendants().noneMatch(tree -> !tree.equals(parameterTree.identifier()) && SyntacticEquivalence.areEquivalent(tree, parameterTree.identifier()))).collect(Collectors.toList());
            if (unusedParameters.isEmpty()) {
                return;
            }
            List<SecondaryLocation> secondaryLocations = unusedParameters.stream().map(unusedParameter -> new SecondaryLocation(unusedParameter.identifier(), "Remove this unused method parameter " + unusedParameter.identifier().name() + "\".")).collect(Collectors.toList());
            IdentifierTree firstUnused = ((ParameterTree)unusedParameters.get(0)).identifier();
            String msg = unusedParameters.size() > 1 ? "Remove these unused function parameters." : "Remove this unused function parameter \"" + firstUnused.name() + "\".";
            ctx.reportIssue((HasTextRange)firstUnused, msg, secondaryLocations);
        });
    }

    private static boolean shouldBeIgnored(CheckContext ctx, FunctionDeclarationTree tree) {
        IdentifierTree name2 = tree.name();
        boolean validFunctionForRule = ctx.parent() instanceof TopLevelTreeImpl || FunctionUtils.isPrivateMethod(tree) && !FunctionUtils.isOverrideMethod(tree);
        return !validFunctionForRule || tree.body() == null || name2 != null && IGNORED_PATTERN.matcher(name2.name()).matches();
    }
}

