/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.impl;

import java.math.BigInteger;
import org.sonarsource.slang.api.IntegerLiteralTree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.impl.LiteralTreeImpl;

public class IntegerLiteralTreeImpl
extends LiteralTreeImpl
implements IntegerLiteralTree {
    private final IntegerLiteralTree.Base base;
    private final String numericPart;

    public IntegerLiteralTreeImpl(TreeMetaData metaData, String stringValue) {
        super(metaData, stringValue);
        if (IntegerLiteralTreeImpl.hasExplicitHexadecimalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.HEXADECIMAL;
            this.numericPart = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitBinaryPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.BINARY;
            this.numericPart = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitDecimalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.DECIMAL;
            this.numericPart = stringValue.substring(2);
        } else if (IntegerLiteralTreeImpl.hasExplicitOctalPrefix(stringValue)) {
            this.base = IntegerLiteralTree.Base.OCTAL;
            this.numericPart = stringValue.substring(2);
        } else if (!stringValue.equals("0") && stringValue.startsWith("0")) {
            this.base = IntegerLiteralTree.Base.OCTAL;
            this.numericPart = stringValue.substring(1);
        } else {
            this.base = IntegerLiteralTree.Base.DECIMAL;
            this.numericPart = stringValue;
        }
    }

    @Override
    public IntegerLiteralTree.Base getBase() {
        return this.base;
    }

    @Override
    public BigInteger getIntegerValue() {
        return new BigInteger(this.numericPart, this.base.getRadix());
    }

    @Override
    public String getNumericPart() {
        return this.numericPart;
    }

    private static boolean hasExplicitOctalPrefix(String value2) {
        return value2.startsWith("0o") || value2.startsWith("0O");
    }

    private static boolean hasExplicitHexadecimalPrefix(String value2) {
        return value2.startsWith("0x") || value2.startsWith("0X");
    }

    private static boolean hasExplicitBinaryPrefix(String value2) {
        return value2.startsWith("0b") || value2.startsWith("0B");
    }

    private static boolean hasExplicitDecimalPrefix(String value2) {
        return value2.startsWith("0d") || value2.startsWith("0D");
    }
}

