/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.markdown;

import org.apache.commons.lang.StringEscapeUtils;
import org.sonar.channel.Channel;
import org.sonar.channel.ChannelDispatcher;
import org.sonar.channel.CodeReader;
import org.sonar.markdown.BlackholeChannel;
import org.sonar.markdown.HtmlBlockquoteChannel;
import org.sonar.markdown.HtmlCodeChannel;
import org.sonar.markdown.HtmlEmphasisChannel;
import org.sonar.markdown.HtmlEndOfLineChannel;
import org.sonar.markdown.HtmlHeadingChannel;
import org.sonar.markdown.HtmlLinkChannel;
import org.sonar.markdown.HtmlListChannel;
import org.sonar.markdown.HtmlMultilineCodeChannel;
import org.sonar.markdown.HtmlUrlChannel;
import org.sonar.markdown.IdentifierAndNumberChannel;
import org.sonar.markdown.MarkdownOutput;

public final class Markdown {
    private ChannelDispatcher<MarkdownOutput> dispatcher = ChannelDispatcher.builder().addChannel((Channel)new HtmlLinkChannel()).addChannel((Channel)new HtmlUrlChannel()).addChannel((Channel)new HtmlEndOfLineChannel()).addChannel((Channel)new HtmlEmphasisChannel()).addChannel((Channel)new HtmlListChannel()).addChannel((Channel)new HtmlBlockquoteChannel()).addChannel((Channel)new HtmlHeadingChannel()).addChannel((Channel)new HtmlCodeChannel()).addChannel((Channel)new HtmlMultilineCodeChannel()).addChannel((Channel)new IdentifierAndNumberChannel()).addChannel((Channel)new BlackholeChannel()).build();

    private Markdown() {
    }

    private String convert(String input) {
        CodeReader reader = new CodeReader(input);
        MarkdownOutput output = new MarkdownOutput();
        this.dispatcher.consume(reader, (Object)output);
        return output.toString();
    }

    public static String convertToHtml(String input) {
        return new Markdown().convert(StringEscapeUtils.escapeHtml((String)input));
    }
}

