/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.measure.Measure;

@Immutable
public class TestMeasure
implements Measure {
    private Integer intValue;
    private Long longValue;
    private Double doubleValue;
    private String stringValue;
    private Boolean booleanValue;

    public static TestMeasure createMeasure(double doubleValue) {
        TestMeasure measure = new TestMeasure();
        measure.doubleValue = doubleValue;
        return measure;
    }

    public static TestMeasure createMeasure(int intValue) {
        TestMeasure measure = new TestMeasure();
        measure.intValue = intValue;
        return measure;
    }

    public static TestMeasure createMeasure(long longValue) {
        TestMeasure measure = new TestMeasure();
        measure.longValue = longValue;
        return measure;
    }

    public static TestMeasure createMeasure(String stringValue) {
        TestMeasure measure = new TestMeasure();
        measure.stringValue = Objects.requireNonNull(stringValue, "Value cannot be null");
        return measure;
    }

    public static TestMeasure createMeasure(boolean booleanValue) {
        TestMeasure measure = new TestMeasure();
        measure.booleanValue = Objects.requireNonNull(Boolean.valueOf(booleanValue), "Value cannot be null");
        return measure;
    }

    @Override
    public int getIntValue() {
        Preconditions.checkState((this.intValue != null ? 1 : 0) != 0, (Object)"Not an integer measure");
        return this.intValue;
    }

    @Override
    public long getLongValue() {
        Preconditions.checkState((this.longValue != null ? 1 : 0) != 0, (Object)"Not a long measure");
        return this.longValue;
    }

    @Override
    public double getDoubleValue() {
        Preconditions.checkState((this.doubleValue != null ? 1 : 0) != 0, (Object)"Not a double measure");
        return this.doubleValue;
    }

    @Override
    public String getStringValue() {
        Preconditions.checkState((this.stringValue != null ? 1 : 0) != 0, (Object)"Not a string measure");
        return this.stringValue;
    }

    @Override
    public boolean getBooleanValue() {
        Preconditions.checkState((this.booleanValue != null ? 1 : 0) != 0, (Object)"Not a boolean measure");
        return this.booleanValue;
    }
}

