/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rule;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class RuleKey
implements Serializable,
Comparable<RuleKey> {
    public static final String EXTERNAL_RULE_REPO_PREFIX = "external_";
    private final String repository;
    private final String rule;
    private final String toString;

    protected RuleKey(String repositoryKey, String ruleKey) {
        this.repository = repositoryKey;
        this.rule = ruleKey;
        this.toString = repositoryKey + ":" + ruleKey;
    }

    public static RuleKey of(String repository, String rule) {
        Preconditions.checkArgument((!StringUtils.isEmpty((String)repository) ? 1 : 0) != 0, (Object)"Repository must be set");
        Preconditions.checkArgument((!StringUtils.isEmpty((String)rule) ? 1 : 0) != 0, (Object)"Rule must be set");
        return new RuleKey(repository, rule);
    }

    public static RuleKey parse(String s) {
        int semiColonPos = s.indexOf(58);
        Preconditions.checkArgument((semiColonPos > 0 ? 1 : 0) != 0, (Object)("Invalid rule key: " + s));
        String key = s.substring(0, semiColonPos);
        String repo = s.substring(semiColonPos + 1);
        return RuleKey.of(key, repo);
    }

    public String repository() {
        return this.repository;
    }

    public String rule() {
        return this.rule;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleKey ruleKey = (RuleKey)o;
        return this.repository.equals(ruleKey.repository) && this.rule.equals(ruleKey.rule);
    }

    public int hashCode() {
        int result = this.repository.hashCode();
        result = 31 * result + this.rule.hashCode();
        return result;
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public int compareTo(RuleKey o) {
        int compareRepositories = this.repository.compareTo(o.repository);
        if (compareRepositories == 0) {
            return this.rule.compareTo(o.rule);
        }
        return compareRepositories;
    }
}

