/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.extension;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.api.ExtensionProvider;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.extension.CoreExtension;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.extension.ExtensionProviderSupport;
import org.sonar.core.platform.ComponentContainer;

public abstract class CoreExtensionsInstaller {
    private static final Logger LOG = Loggers.get(CoreExtensionsInstaller.class);
    private final SonarRuntime sonarRuntime;
    private final CoreExtensionRepository coreExtensionRepository;
    private final Class<? extends Annotation> supportedAnnotationType;

    public static Predicate<Object> noExtensionFilter() {
        return t -> true;
    }

    public static Predicate<Object> noAdditionalSideFilter() {
        return t -> true;
    }

    protected CoreExtensionsInstaller(SonarRuntime sonarRuntime, CoreExtensionRepository coreExtensionRepository, Class<? extends Annotation> supportedAnnotationType) {
        this.sonarRuntime = sonarRuntime;
        this.coreExtensionRepository = coreExtensionRepository;
        this.supportedAnnotationType = supportedAnnotationType;
    }

    public void install(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter) {
        this.coreExtensionRepository.loadedCoreExtensions().forEach(coreExtension -> this.install(container, extensionFilter, additionalSideFilter, (CoreExtension)coreExtension));
    }

    private void install(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, CoreExtension coreExtension) {
        String coreExtensionName = coreExtension.getName();
        try {
            List<Object> providerKeys = this.addDeclaredExtensions(container, extensionFilter, additionalSideFilter, coreExtension);
            this.addProvidedExtensions(container, additionalSideFilter, coreExtensionName, providerKeys);
            LOG.debug("Installed core extension: " + coreExtensionName);
            this.coreExtensionRepository.installed(coreExtension);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load core extension " + coreExtensionName, e);
        }
    }

    private List<Object> addDeclaredExtensions(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, CoreExtension coreExtension) {
        ContextImpl context = new ContextImpl(container, extensionFilter, additionalSideFilter, coreExtension.getName());
        coreExtension.load(context);
        return context.getProviders();
    }

    private void addProvidedExtensions(ComponentContainer container, Predicate<Object> additionalSideFilter, String extensionCategory, List<Object> providerKeys) {
        providerKeys.stream().map(providerKey -> (ExtensionProvider)container.getComponentByKey(providerKey)).forEach(provider -> this.addFromProvider(container, additionalSideFilter, extensionCategory, (ExtensionProvider)provider));
    }

    private void addFromProvider(ComponentContainer container, Predicate<Object> additionalSideFilter, String extensionCategory, ExtensionProvider provider) {
        Object obj = provider.provide();
        if (obj != null) {
            if (obj instanceof Iterable) {
                for (Object ext : (Iterable)obj) {
                    this.addSupportedExtension(container, additionalSideFilter, extensionCategory, ext);
                }
            } else {
                this.addSupportedExtension(container, additionalSideFilter, extensionCategory, obj);
            }
        }
    }

    private <T> boolean addSupportedExtension(ComponentContainer container, Predicate<Object> additionalSideFilter, String extensionCategory, T component) {
        if (this.hasSupportedAnnotation(component) && additionalSideFilter.test(component)) {
            container.addExtension(extensionCategory, component);
            return true;
        }
        return false;
    }

    private <T> boolean hasSupportedAnnotation(T component) {
        return AnnotationUtils.getAnnotation(component, this.supportedAnnotationType) != null;
    }

    private class ContextImpl
    implements CoreExtension.Context {
        private final ComponentContainer container;
        private final Predicate<Object> extensionFilter;
        private final Predicate<Object> additionalSideFilter;
        private final String extensionCategory;
        private final List<Object> providers = new ArrayList<Object>();

        public ContextImpl(ComponentContainer container, Predicate<Object> extensionFilter, Predicate<Object> additionalSideFilter, String extensionCategory) {
            this.container = container;
            this.extensionFilter = extensionFilter;
            this.additionalSideFilter = additionalSideFilter;
            this.extensionCategory = extensionCategory;
        }

        @Override
        public SonarRuntime getRuntime() {
            return CoreExtensionsInstaller.this.sonarRuntime;
        }

        @Override
        public Configuration getBootConfiguration() {
            return Optional.ofNullable(this.container.getComponentByType(Configuration.class)).orElseGet(() -> new MapSettings().asConfig());
        }

        @Override
        public CoreExtension.Context addExtension(Object component) {
            Objects.requireNonNull(component, "component can't be null");
            if (!this.extensionFilter.test(component)) {
                return this;
            }
            if (!CoreExtensionsInstaller.this.addSupportedExtension(this.container, this.additionalSideFilter, this.extensionCategory, component)) {
                this.container.declareExtension(this.extensionCategory, component);
            } else if (ExtensionProviderSupport.isExtensionProvider(component)) {
                this.providers.add(component);
            }
            return this;
        }

        @Override
        public final CoreExtension.Context addExtensions(Object component, Object ... otherComponents) {
            this.addExtension(component);
            Arrays.stream(otherComponents).forEach(this::addExtension);
            return this;
        }

        @Override
        public <T> CoreExtension.Context addExtensions(Collection<T> components) {
            Objects.requireNonNull(components, "components can't be null");
            components.forEach(this::addExtension);
            return this;
        }

        public List<Object> getProviders() {
            return this.providers;
        }
    }
}

