/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.internal.pmd;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.api.batch.sensor.cpd.internal.TokensLine;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.cpd.FileCodeLoaderWithoutCache;
import org.sonar.duplications.internal.pmd.PmdBlockChunker;

public class TokenizerBridge {
    private final Tokenizer tokenizer;
    private final PmdBlockChunker blockBuilder;

    public TokenizerBridge(Tokenizer tokenizer, int blockSize) {
        this.tokenizer = tokenizer;
        this.blockBuilder = new PmdBlockChunker(blockSize);
    }

    public List<Block> chunk(String resourceId, String fileName, Reader fileReader) {
        return this.blockBuilder.chunk(resourceId, this.chunk(fileName, fileReader));
    }

    public List<TokensLine> chunk(String fileName, Reader fileReader) {
        SourceCode sourceCode = new SourceCode(new FileCodeLoaderWithoutCache(fileName, fileReader));
        Tokens tokens = new Tokens();
        TokenEntry.clearImages();
        try {
            this.tokenizer.tokenize(sourceCode, tokens);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        TokenEntry.clearImages();
        return TokenizerBridge.convert(tokens.getTokens());
    }

    public static List<TokensLine> convert(List<TokenEntry> tokens) {
        ArrayList<TokensLine> result = new ArrayList<TokensLine>();
        StringBuilder sb = new StringBuilder();
        int startLine = Integer.MIN_VALUE;
        int startIndex = 0;
        int currentIndex = 0;
        for (TokenEntry token : tokens) {
            if (token == TokenEntry.EOF) continue;
            String value = token.getValue();
            int line = token.getBeginLine();
            if (line != startLine) {
                TokenizerBridge.addNewTokensLine(result, startIndex, currentIndex, startLine, sb);
                startIndex = currentIndex + 1;
                startLine = line;
            }
            ++currentIndex;
            sb.append(value);
        }
        TokenizerBridge.addNewTokensLine(result, startIndex, currentIndex, startLine, sb);
        return result;
    }

    private static void addNewTokensLine(List<TokensLine> result, int startUnit, int endUnit, int startLine, StringBuilder sb) {
        if (sb.length() != 0) {
            result.add(new TokensLine(startUnit, endUnit, startLine, sb.toString()));
            sb.setLength(0);
        }
    }
}

