/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.scanner.bootstrap.RawScannerProperties;
import org.sonar.scanner.scan.ExternalProjectKeyAndOrganization;

@Immutable
public class ProcessedScannerProperties
implements ProjectKey {
    private final Map<String, String> properties = new HashMap<String, String>();

    public ProcessedScannerProperties(RawScannerProperties rawScannerProperties, ExternalProjectKeyAndOrganization externalProjectKeyAndOrganization) {
        this.properties.putAll(rawScannerProperties.properties());
        externalProjectKeyAndOrganization.getProjectKey().ifPresent(projectKey -> this.properties.put("sonar.projectKey", (String)projectKey));
        externalProjectKeyAndOrganization.getOrganization().ifPresent(organization -> this.properties.put("sonar.organization", (String)organization));
    }

    public Map<String, String> properties() {
        return ImmutableMap.copyOf(this.properties);
    }

    public String property(String key) {
        return this.properties.get(key);
    }

    @Override
    public String get() {
        return this.getKeyWithBranch();
    }

    private String getKey() {
        return this.properties.get("sonar.projectKey");
    }

    public String getKeyWithBranch() {
        String branch = this.getBranch();
        String projectKey = this.getKey();
        if (branch == null) {
            return projectKey;
        }
        return String.format("%s:%s", projectKey, branch);
    }

    @CheckForNull
    private String getBranch() {
        return StringUtils.trimToNull(this.properties.get("sonar.branch"));
    }
}

