/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.issue.DefaultFilterableIssue;

public class IgnoreIssuesFilter
implements IssueFilter {
    private Multimap<InputComponent, WildcardPattern> rulePatternByComponent = LinkedHashMultimap.create();
    private static final Logger LOG = Loggers.get(IgnoreIssuesFilter.class);

    @Override
    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        InputComponent component = ((DefaultFilterableIssue)issue).getComponent();
        if (component.isFile() && ((DefaultInputFile)component).isIgnoreAllIssues()) {
            return false;
        }
        if (component.isFile() && ((DefaultInputFile)component).isIgnoreAllIssuesOnLine(issue.line())) {
            return false;
        }
        if (this.hasRuleMatchFor(component, issue)) {
            return false;
        }
        return chain.accept(issue);
    }

    public void addRuleExclusionPatternForComponent(DefaultInputFile inputFile, WildcardPattern rulePattern) {
        if ("*".equals(rulePattern.toString())) {
            inputFile.setIgnoreAllIssues(true);
        } else {
            this.rulePatternByComponent.put(inputFile, rulePattern);
        }
    }

    private boolean hasRuleMatchFor(InputComponent component, FilterableIssue issue) {
        for (WildcardPattern pattern : this.rulePatternByComponent.get(component)) {
            if (!pattern.match(issue.ruleKey().toString())) continue;
            LOG.debug("Issue {} ignored by exclusion pattern {}", (Object)issue, (Object)pattern);
            return true;
        }
        return false;
    }
}

