/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.sonarqube.ws.FilenameUtils;
import org.sonarqube.ws.WsUtils;

public final class MediaTypes {
    public static final String JSON = "application/json";
    public static final String XML = "application/xml";
    public static final String TXT = "text/plain";
    public static final String PROTOBUF = "application/x-protobuf";
    public static final String ZIP = "application/zip";
    public static final String JAVASCRIPT = "application/javascript";
    public static final String HTML = "text/html";
    public static final String DEFAULT = "application/octet-stream";
    public static final String SVG = "image/svg+xml";
    private static final Map<String, String> MAP = new HashMap<String, String>();

    private MediaTypes() {
    }

    public static String getByFilename(String filename) {
        String extension = FilenameUtils.getExtension(filename);
        String mime = null;
        if (!WsUtils.isNullOrEmpty(extension)) {
            mime = MAP.get(extension.toLowerCase(Locale.ENGLISH));
        }
        return mime != null ? mime : DEFAULT;
    }

    static {
        MAP.put("js", JAVASCRIPT);
        MAP.put("json", JSON);
        MAP.put("zip", ZIP);
        MAP.put("tgz", "application/tgz");
        MAP.put("ps", "application/postscript");
        MAP.put("jnlp", "application/jnlp");
        MAP.put("jar", "application/java-archive");
        MAP.put("xls", "application/vnd.ms-excel");
        MAP.put("ppt", "application/vnd.ms-powerpoint");
        MAP.put("tar", "application/x-tar");
        MAP.put("xml", XML);
        MAP.put("dtd", "application/xml-dtd");
        MAP.put("xslt", "application/xslt+xml");
        MAP.put("bmp", "image/bmp");
        MAP.put("gif", "image/gif");
        MAP.put("jpg", "image/jpeg");
        MAP.put("jpeg", "image/jpeg");
        MAP.put("tiff", "image/tiff");
        MAP.put("png", "image/png");
        MAP.put("svg", SVG);
        MAP.put("ico", "image/x-icon");
        MAP.put("txt", TXT);
        MAP.put("csv", "text/csv");
        MAP.put("properties", TXT);
        MAP.put("rtf", "text/rtf");
        MAP.put("html", HTML);
        MAP.put("css", "text/css");
        MAP.put("tsv", "text/tab-separated-values");
    }
}

