/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.charset;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.platform.db.migration.charset.CharsetHandler;
import org.sonar.server.platform.db.migration.charset.DatabaseCharsetChecker;
import org.sonar.server.platform.db.migration.charset.SqlExecutor;

class OracleCharsetHandler
extends CharsetHandler {
    OracleCharsetHandler(SqlExecutor selectExecutor) {
        super(selectExecutor);
    }

    @Override
    public void handle(Connection connection, DatabaseCharsetChecker.State state) throws SQLException {
        if (state == DatabaseCharsetChecker.State.FRESH_INSTALL) {
            Loggers.get(this.getClass()).info("Verify that database charset is UTF8");
            this.expectUtf8(connection);
        }
    }

    private void expectUtf8(Connection connection) throws SQLException {
        String charset = this.getSqlExecutor().selectSingleString(connection, "select value from nls_database_parameters where parameter='NLS_CHARACTERSET'");
        if (!StringUtils.containsIgnoreCase((String)charset, (String)"utf8")) {
            throw MessageException.of((String)String.format("Oracle NLS_CHARACTERSET does not support UTF8: %s", charset));
        }
    }
}

