/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.def;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.AbstractColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

@Immutable
public class DecimalColumnDef
extends AbstractColumnDef {
    public static final int DEFAULT_PRECISION = 38;
    public static final int DEFAULT_SCALE = 20;
    private final int precision;
    private final int scale;

    private DecimalColumnDef(Builder builder) {
        super(builder.columnName, builder.isNullable, null);
        this.precision = builder.precision;
        this.scale = builder.scale;
    }

    public static Builder newDecimalColumnDefBuilder() {
        return new Builder();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String generateSqlType(Dialect dialect) {
        switch (dialect.getId()) {
            case "postgresql": 
            case "oracle": {
                return String.format("NUMERIC (%s,%s)", this.precision, this.scale);
            }
            case "mysql": 
            case "mssql": {
                return String.format("DECIMAL (%s,%s)", this.precision, this.scale);
            }
            case "h2": {
                return "DOUBLE";
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown dialect '%s'", dialect.getId()));
    }

    public static class Builder {
        @CheckForNull
        private String columnName;
        private int precision = 38;
        private int scale = 20;
        private boolean isNullable = true;

        public Builder setColumnName(String columnName) {
            this.columnName = Validations.validateColumnName(columnName);
            return this;
        }

        public Builder setIsNullable(boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public DecimalColumnDef build() {
            Validations.validateColumnName(this.columnName);
            return new DecimalColumnDef(this);
        }
    }
}

