/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.history;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.MigrationSteps;
import org.sonar.server.platform.db.migration.step.RegisteredMigrationStep;

public class MigrationHistoryMeddler {
    private final Map<Long, Long> meddledSteps = ImmutableMap.of((Object)1923L, (Object)1959L);
    private final MigrationSteps migrationSteps;

    public MigrationHistoryMeddler(MigrationSteps migrationSteps) {
        this.migrationSteps = migrationSteps;
    }

    public void meddle(MigrationHistory migrationHistory) {
        migrationHistory.getLastMigrationNumber().ifPresent(migrationNumber -> {
            Long newMigrationNumber = this.meddledSteps.get(migrationNumber);
            if (newMigrationNumber != null) {
                RegisteredMigrationStep registeredMigrationStep = this.migrationSteps.readFrom(newMigrationNumber).get(0);
                migrationHistory.done(registeredMigrationStep);
            }
        });
    }
}

