/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v60;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex
extends DataChange {
    public PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex(Database db) {
        super(db);
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex.populateComponentUuid(context);
        PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex.populateAnalysisUuid(context);
    }

    private static void populateComponentUuid(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct di.snapshot_id, s.component_uuid from duplications_index di inner join snapshots s on s.id=di.snapshot_id where di.component_uuid is null");
        massUpdate.update("UPDATE duplications_index SET component_uuid=? WHERE snapshot_id=? and component_uuid is null");
        massUpdate.rowPluralName("component uuid of duplications_index entries");
        massUpdate.execute(PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex::handleComponentUuid);
    }

    private static boolean handleComponentUuid(Select.Row row, SqlStatement update) throws SQLException {
        long snapshotId = row.getLong(1);
        String componentUuid = row.getString(2);
        update.setString(1, componentUuid);
        update.setLong(2, snapshotId);
        return true;
    }

    private static void populateAnalysisUuid(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select distinct di.project_snapshot_id, s.uuid from duplications_index di inner join snapshots s on s.id=di.project_snapshot_id where di.analysis_uuid is null");
        massUpdate.update("UPDATE duplications_index SET analysis_uuid=? WHERE project_snapshot_id=? and analysis_uuid is null");
        massUpdate.rowPluralName("analysis uuid of duplications_index entries");
        massUpdate.execute(PopulateComponentUuidAndAnalysisUuidOfDuplicationsIndex::handleAnalysisUuid);
    }

    private static boolean handleAnalysisUuid(Select.Row row, SqlStatement update) throws SQLException {
        long projectSnapshotId = row.getLong(1);
        String snapshotUuid = row.getString(2);
        update.setString(1, snapshotUuid);
        update.setLong(2, projectSnapshotId);
        return true;
    }
}

