/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v61;

import java.sql.SQLException;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;

public class RemoveViewsDefinitionFromProperties
extends DataChange {
    private static final String VIEWS_DEFINITION_PROPERTY_KEY = "views.def";
    private static final int VARCHAR_MAX_LENGTH = 4000;
    private final System2 system2;

    public RemoveViewsDefinitionFromProperties(Database db, System2 system2) {
        super(db);
        this.system2 = system2;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        String property = ((Select)context.prepareSelect("select text_value from properties where prop_key=?").setString(1, VIEWS_DEFINITION_PROPERTY_KEY)).get(row -> row.getNullableString(1));
        Integer hasInternalProperty = ((Select)context.prepareSelect("select 1 from internal_properties where kee=?").setString(1, VIEWS_DEFINITION_PROPERTY_KEY)).get(row -> row.getNullableInt(1));
        if (hasInternalProperty == null) {
            this.addToInternalProperties(context, property);
        }
        RemoveViewsDefinitionFromProperties.deleteFromProperties(context);
    }

    private void addToInternalProperties(DataChange.Context context, @Nullable String property) throws SQLException {
        if (property != null) {
            boolean mustBeStoredInClob = property.length() > 4000;
            try (Upsert insert = context.prepareUpsert("insert into internal_properties (kee, is_empty, " + (mustBeStoredInClob ? "clob_value" : "text_value") + ", created_at) values (?,?,?,?)");){
                long now = this.system2.now();
                ((Upsert)((Upsert)((Upsert)((Upsert)insert.setString(1, VIEWS_DEFINITION_PROPERTY_KEY)).setBoolean(2, false)).setString(3, property)).setLong(4, now)).execute().commit();
            }
        }
    }

    private static void deleteFromProperties(DataChange.Context context) throws SQLException {
        try (Upsert delete = context.prepareUpsert("delete from properties where prop_key=?");){
            ((Upsert)delete.setString(1, VIEWS_DEFINITION_PROPERTY_KEY)).execute().commit();
        }
    }
}

