/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v70;

import java.sql.SQLException;
import java.util.Date;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateUuidOnQualityGates
extends DataChange {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public PopulateUuidOnQualityGates(Database db, System2 system2, UuidFactory uuidFactory) {
        super(db);
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, name from quality_gates where uuid is null");
        massUpdate.rowPluralName("quality gates");
        massUpdate.update("update quality_gates set uuid=?, updated_at=? where id=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, this.uuidFactory.create());
            update.setDate(2, new Date(this.system2.now()));
            update.setLong(3, row.getLong(1));
            return true;
        });
    }
}

