/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v71;

import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class UseRuleIdInQPChangesData
extends DataChange {
    private static final String RULE_KEY_DATA_FIELD = "ruleKey";
    private static final String RULE_ID_DATA_FIELD = "ruleId";

    public UseRuleIdInQPChangesData(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        Map<String, Integer> ruleKeysById = context.prepareSelect("select id, plugin_name, plugin_rule_key from rules").list(row -> new Rule(row.getInt(1), RuleKey.of((String)row.getString(2), (String)row.getString(3)).toString())).stream().collect(Collectors.toMap(r -> ((Rule)r).ruleKey, r -> ((Rule)r).ruleId));
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select kee,change_data from qprofile_changes");
        massUpdate.update("update qprofile_changes set change_data=? where kee=?");
        massUpdate.execute((Select.Row row, SqlStatement update) -> UseRuleIdInQPChangesData.handle(row, update, ruleKeysById));
    }

    private static boolean handle(Select.Row row, SqlStatement update, Map<String, Integer> ruleKeysById) throws SQLException {
        String key = row.getString(1);
        String data = row.getString(2);
        Map map = KeyValueFormat.parse((String)data);
        String ruleKey = (String)map.get(RULE_KEY_DATA_FIELD);
        if (ruleKey == null) {
            return false;
        }
        Integer ruleId = ruleKeysById.get(ruleKey);
        if (ruleId != null) {
            map.put(RULE_ID_DATA_FIELD, String.valueOf(ruleId));
        }
        map.remove(RULE_KEY_DATA_FIELD);
        update.setString(1, KeyValueFormat.format((Map)map));
        update.setString(2, key);
        return true;
    }

    private static final class Rule {
        private final int ruleId;
        private final String ruleKey;

        private Rule(int ruleId, String ruleKey) {
            this.ruleId = ruleId;
            this.ruleKey = ruleKey;
        }
    }
}

