/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v74;

import java.sql.SQLException;
import org.sonar.api.config.Configuration;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.Upsert;
import org.sonar.server.platform.db.migration.version.v63.DefaultOrganizationUuidProvider;

@SupportsBlueGreen
public class AddApplicationCreatorAndPortfolioCreatorToSonarAdministrator
extends DataChange {
    private final Configuration configuration;
    private final DefaultOrganizationUuidProvider defaultOrganizationUuidProvider;

    public AddApplicationCreatorAndPortfolioCreatorToSonarAdministrator(Database db, Configuration configuration, DefaultOrganizationUuidProvider defaultOrganizationUuidProvider) {
        super(db);
        this.configuration = configuration;
        this.defaultOrganizationUuidProvider = defaultOrganizationUuidProvider;
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        if (this.configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false).booleanValue()) {
            return;
        }
        Integer sonarAdmGroupId = ((Select)context.prepareSelect("SELECT id FROM groups WHERE name=?").setString(1, "sonar-administrators")).get(r -> r.getInt(1));
        if (sonarAdmGroupId == null) {
            return;
        }
        this.insertPermissionIfMissing(context, sonarAdmGroupId, "applicationcreator");
        this.insertPermissionIfMissing(context, sonarAdmGroupId, "portfoliocreator");
    }

    private void insertPermissionIfMissing(DataChange.Context context, Integer sonarAdmGroupId, String role) throws SQLException {
        if (AddApplicationCreatorAndPortfolioCreatorToSonarAdministrator.isPermissionMissing(context, sonarAdmGroupId, role)) {
            ((Upsert)((Upsert)((Upsert)context.prepareUpsert("INSERT INTO group_roles(organization_uuid, group_id, role) VALUES(?, ?, ?)").setString(1, this.defaultOrganizationUuidProvider.get(context))).setInt(2, sonarAdmGroupId)).setString(3, role)).execute().commit();
        }
    }

    private static boolean isPermissionMissing(DataChange.Context context, Integer sonarAdmGroupId, String role) throws SQLException {
        Integer count = ((Select)((Select)context.prepareSelect("SELECT COUNT(id) FROM group_roles WHERE group_id=? AND role=?").setInt(1, sonarAdmGroupId)).setString(2, role)).get(r -> r.getInt(1));
        return count == null || count == 0;
    }
}

