/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v78;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.es.MigrationEsClient;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class UpdateSecurityHotspotsStatuses
extends DataChange {
    private static final String RESOLUTION_FIXED = "FIXED";
    private static final String RESOLUTION_WONT_FIX = "WONTFIX";
    private static final String STATUS_OPEN = "OPEN";
    private static final String STATUS_REOPENED = "REOPENED";
    private static final String STATUS_RESOLVED = "RESOLVED";
    private static final String STATUS_TO_REVIEW = "TO_REVIEW";
    private static final String STATUS_IN_REVIEW = "IN_REVIEW";
    private static final String STATUS_REVIEWED = "REVIEWED";
    private static final int RULE_TYPE_SECURITY_HOTSPOT = 4;
    private final Configuration configuration;
    private final System2 system2;
    private final MigrationEsClient esClient;
    private final UuidFactory uuidFactory;

    public UpdateSecurityHotspotsStatuses(Database db, Configuration configuration, System2 system2, MigrationEsClient esClient, UuidFactory uuidFactory) {
        super(db);
        this.configuration = configuration;
        this.system2 = system2;
        this.esClient = esClient;
        this.uuidFactory = uuidFactory;
    }

    @Override
    public void execute(DataChange.Context context) throws SQLException {
        if (this.configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false).booleanValue()) {
            return;
        }
        long now = this.system2.now();
        MassUpdate massUpdate = context.prepareMassUpdate().rowPluralName("security hotspots");
        massUpdate.select("select i.kee, i.status, i.resolution, i.issue_type from issues i inner join rules r on r.id = i.rule_id and r.rule_type = ? where (i.resolution is null or i.resolution in (?, ?)) and i.issue_type=? and i.status not in (?, ?, ?)").setInt(1, 4).setString(2, RESOLUTION_FIXED).setString(3, RESOLUTION_WONT_FIX).setInt(4, 4).setString(5, STATUS_TO_REVIEW).setString(6, STATUS_IN_REVIEW).setString(7, STATUS_REVIEWED);
        massUpdate.update("update issues set status=?, resolution=?, updated_at=? where kee=? ");
        massUpdate.update("insert into issue_changes (kee, issue_key, change_type, change_data, created_at, updated_at, issue_change_creation_date) values (?, ?, 'diff', ?, ?, ?, ?)");
        massUpdate.execute((Select.Row row, SqlStatement update, int updateIndex) -> {
            String issueKey = row.getString(1);
            String status = row.getString(2);
            String resolution = row.getNullableString(3);
            IssueUpdate issueUpdate = new IssueUpdate(status, resolution);
            FieldDiffs fieldDiffs = issueUpdate.process();
            if (!issueUpdate.isUpdated()) {
                return false;
            }
            if (updateIndex == 0) {
                update.setString(1, issueUpdate.getNewStatus());
                update.setString(2, issueUpdate.getNewResolution());
                update.setLong(3, now);
                update.setString(4, issueKey);
                return true;
            }
            if (!status.equals(STATUS_OPEN)) {
                update.setString(1, this.uuidFactory.create());
                update.setString(2, issueKey);
                update.setString(3, fieldDiffs.toEncodedString());
                update.setLong(4, now);
                update.setLong(5, now);
                update.setLong(6, now);
                return true;
            }
            return false;
        });
        this.esClient.deleteIndexes("issues", new String[0]);
    }

    static class FieldDiffs
    implements Serializable {
        private final Map<String, Diff> diffs = Maps.newLinkedHashMap();

        FieldDiffs() {
        }

        void setDiff(String field, @Nullable String oldValue, @Nullable String newValue) {
            this.diffs.put(field, new Diff(oldValue, newValue));
        }

        String toEncodedString() {
            StringBuilder sb = new StringBuilder();
            boolean notFirst = false;
            for (Map.Entry<String, Diff> entry : this.diffs.entrySet()) {
                if (notFirst) {
                    sb.append(',');
                } else {
                    notFirst = true;
                }
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue().toEncodedString());
            }
            return sb.toString();
        }

        static class Diff
        implements Serializable {
            private String oldValue;
            private String newValue;

            Diff(@Nullable String oldValue, @Nullable String newValue) {
                this.oldValue = oldValue;
                this.newValue = newValue;
            }

            private String toEncodedString() {
                StringBuilder sb = new StringBuilder();
                if (this.oldValue != null) {
                    sb.append(this.oldValue);
                    sb.append('|');
                }
                if (this.newValue != null) {
                    sb.append(this.newValue);
                }
                return sb.toString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Diff diff = (Diff)o;
                return Objects.equals(this.oldValue, diff.oldValue) && Objects.equals(this.newValue, diff.newValue);
            }

            public int hashCode() {
                return Objects.hash(this.oldValue, this.newValue);
            }
        }
    }

    private static class IssueUpdate {
        private static final String RESOLUTION_FIELD = "resolution";
        private static final String STATUS_FIELD = "status";
        private final String status;
        private final String resolution;
        private String newStatus;
        private String newResolution;
        private boolean updated;

        IssueUpdate(String status, @CheckForNull String resolution) {
            this.status = status;
            this.resolution = resolution;
        }

        FieldDiffs process() {
            if ((this.status.equals(UpdateSecurityHotspotsStatuses.STATUS_OPEN) || this.status.equals(UpdateSecurityHotspotsStatuses.STATUS_REOPENED)) && this.resolution == null) {
                this.newStatus = UpdateSecurityHotspotsStatuses.STATUS_TO_REVIEW;
                this.newResolution = null;
                this.updated = true;
            } else if (this.status.equals(UpdateSecurityHotspotsStatuses.STATUS_RESOLVED) && this.resolution != null) {
                if (this.resolution.equals(UpdateSecurityHotspotsStatuses.RESOLUTION_FIXED)) {
                    this.newStatus = UpdateSecurityHotspotsStatuses.STATUS_IN_REVIEW;
                    this.newResolution = null;
                    this.updated = true;
                } else if (this.resolution.equals(UpdateSecurityHotspotsStatuses.RESOLUTION_WONT_FIX)) {
                    this.newStatus = UpdateSecurityHotspotsStatuses.STATUS_REVIEWED;
                    this.newResolution = UpdateSecurityHotspotsStatuses.RESOLUTION_FIXED;
                    this.updated = true;
                }
            }
            FieldDiffs fieldDiffs = new FieldDiffs();
            fieldDiffs.setDiff(STATUS_FIELD, this.status, this.newStatus);
            fieldDiffs.setDiff(RESOLUTION_FIELD, this.resolution, this.newResolution);
            return fieldDiffs;
        }

        String getNewStatus() {
            return this.newStatus;
        }

        String getNewResolution() {
            return this.newResolution;
        }

        boolean isUpdated() {
            return this.updated;
        }
    }
}

