/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeBuffer;
import org.sonar.channel.CodeReader;
import org.sonar.duplications.token.Token;
import org.sonar.duplications.token.TokenQueue;

class TokenChannel
extends Channel<TokenQueue> {
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private String normalizationValue;

    public TokenChannel(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
    }

    public TokenChannel(String regex, String normalizationValue) {
        this(regex);
        this.normalizationValue = normalizationValue;
    }

    public boolean consume(CodeReader code, TokenQueue output) {
        if (code.popTo(this.matcher, (Appendable)this.tmpBuilder) > 0) {
            CodeBuffer.Cursor previousCursor = code.getPreviousCursor();
            if (this.normalizationValue != null) {
                output.add(new Token(this.normalizationValue, previousCursor.getLine(), previousCursor.getColumn()));
            } else {
                output.add(new Token(this.tmpBuilder.toString(), previousCursor.getLine(), previousCursor.getColumn()));
            }
            this.tmpBuilder.setLength(0);
            return true;
        }
        return false;
    }
}

