/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileWeight;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private ProfileWeight profileWeight;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;
    private final boolean isConstantScoreQuery;

    ProfileScorer(ProfileWeight w, Scorer scorer, QueryProfileBreakdown profile) throws IOException {
        super((Weight)w);
        Scorer childScorer;
        this.scorer = scorer;
        this.profileWeight = w;
        this.scoreTimer = profile.getTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getTimer(QueryTimingType.MATCH);
        ProfileScorer profileScorer = null;
        if (w.getQuery() instanceof ConstantScoreQuery && scorer instanceof ProfileScorer) {
            profileScorer = (ProfileScorer)scorer;
        } else if (w.getQuery() instanceof ConstantScoreQuery && scorer.getChildren().size() == 1 && (childScorer = ((Scorer.ChildScorer)scorer.getChildren().iterator().next()).child) instanceof ProfileScorer) {
            profileScorer = (ProfileScorer)childScorer;
        }
        if (profileScorer != null) {
            this.isConstantScoreQuery = true;
            profile.setTimer(QueryTimingType.NEXT_DOC, profileScorer.nextDocTimer);
            profile.setTimer(QueryTimingType.ADVANCE, profileScorer.advanceTimer);
            profile.setTimer(QueryTimingType.MATCH, profileScorer.matchTimer);
        } else {
            this.isConstantScoreQuery = false;
        }
    }

    public int docID() {
        return this.scorer.docID();
    }

    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    public Weight getWeight() {
        return this.profileWeight;
    }

    public Collection<Scorer.ChildScorer> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    public DocIdSetIterator iterator() {
        if (this.isConstantScoreQuery) {
            return this.scorer.iterator();
        }
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            public int docID() {
                return in.docID();
            }

            public long cost() {
                return in.cost();
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        if (this.isConstantScoreQuery) {
            return this.scorer.twoPhaseIterator();
        }
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            public int docID() {
                return inApproximation.docID();
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            public float matchCost() {
                return in.matchCost();
            }
        };
    }
}

