/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import com.google.common.base.Preconditions;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.CeTaskInterrupter;
import org.sonar.ce.taskprocessor.CeWorkerController;
import org.sonar.ce.taskprocessor.SimpleCeTaskInterrupter;
import org.sonar.ce.taskprocessor.TimeoutCeTaskInterrupter;

public class CeTaskInterrupterProvider
extends ProviderAdapter {
    private static final String PROPERTY_CE_TASK_TIMEOUT = "sonar.ce.task.timeoutSeconds";
    private CeTaskInterrupter instance;

    public CeTaskInterrupter provide(Configuration configuration, CeWorkerController ceWorkerController, System2 system2) {
        if (this.instance == null) {
            this.instance = configuration.getLong(PROPERTY_CE_TASK_TIMEOUT).filter(timeOutInSeconds -> {
                Preconditions.checkState((timeOutInSeconds >= 1L ? 1 : 0) != 0, (String)"The property '%s' must be a long value >= 1. Got '%s'", (Object[])new Object[]{PROPERTY_CE_TASK_TIMEOUT, timeOutInSeconds});
                return true;
            }).map(timeOutInSeconds -> new TimeoutCeTaskInterrupter(timeOutInSeconds * 1000L, ceWorkerController, system2)).orElseGet(SimpleCeTaskInterrupter::new);
        }
        return this.instance;
    }
}

