/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.Version;
import org.sonar.db.dialect.Dialect;

abstract class AbstractDialect
implements Dialect {
    private final String id;
    private final String defaultDriverClassName;
    private final String trueSqlValue;
    private final String falseSqlValue;
    private final String validationQuery;

    protected AbstractDialect(String id, String defaultDriverClassName, String trueSqlValue, String falseSqlValue, String validationQuery) {
        this.id = id;
        this.defaultDriverClassName = defaultDriverClassName;
        this.trueSqlValue = trueSqlValue;
        this.falseSqlValue = falseSqlValue;
        this.validationQuery = validationQuery;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultDriverClassName() {
        return this.defaultDriverClassName;
    }

    @Override
    public final String getTrueSqlValue() {
        return this.trueSqlValue;
    }

    @Override
    public final String getFalseSqlValue() {
        return this.falseSqlValue;
    }

    @Override
    public String getSqlFromDual() {
        return "";
    }

    @Override
    public final String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    public List<String> getConnectionInitStatements() {
        return Collections.emptyList();
    }

    @Override
    public int getScrollDefaultFetchSize() {
        return 200;
    }

    @Override
    public int getScrollSingleRowFetchSize() {
        return 1;
    }

    @Override
    public boolean supportsUpsert() {
        return false;
    }

    Version checkDbVersion(DatabaseMetaData metaData, Version minSupported) throws SQLException {
        int minor;
        int major = metaData.getDatabaseMajorVersion();
        Version version = Version.create((int)major, (int)(minor = metaData.getDatabaseMinorVersion()), (int)0);
        if (version.compareTo(minSupported) < 0) {
            throw MessageException.of((String)String.format("Unsupported %s version: %s. Minimal supported version is %s.", this.getId(), version, minSupported));
        }
        return version;
    }
}

